"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDateHistogram = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _documentation_links = require("../../../services/documentation_links");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  parseEsInterval
} = _public.search.aggs;
const timeZoneOptions = _momentTimezone.default.tz.names().map(name => ({
  value: name,
  text: name
}));
class StepDateHistogram extends _react.Component {
  static getDerivedStateFromProps(props) {
    const {
      dateFields
    } = props;
    const dateHistogramFieldOptions = dateFields.map(dateField => ({
      value: dateField,
      text: dateField
    }));
    return {
      dateHistogramFieldOptions
    };
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "renderErrors", () => {
      const {
        areStepErrorsVisible,
        hasErrors
      } = this.props;
      if (!areStepErrorsVisible || !hasErrors) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_components.StepError, null);
    });
    this.state = {
      dateHistogramFieldOptions: []
    };
  }
  renderIntervalHelpText() {
    const {
      fields
    } = this.props;
    const {
      dateHistogramInterval
    } = fields;
    let preferFixedWarning;
    try {
      const {
        value,
        unit
      } = parseEsInterval(dateHistogramInterval);
      if (value === 1) {
        switch (unit) {
          case 'd':
            preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
              color: "warning"
            }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningDayLabel",
              defaultMessage: "Consider using 24h instead of 1d. This allows for more flexible queries."
            })));
            break;
          case 'h':
            preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
              color: "warning"
            }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningHourLabel",
              defaultMessage: "Consider using 60m instead of 1h. This allows for more flexible queries."
            })));
            break;
        }
      }
      switch (unit) {
        case 'y':
          preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "warning"
          }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningYearLabel",
            defaultMessage: "Consider using the d unit instead of y. This allows for more flexible queries."
          })));
          break;
        case 'M':
          preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "warning"
          }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningMonthLabel",
            defaultMessage: "Consider using the d unit instead of M. This allows for more flexible queries."
          })));
          break;
        case 'w':
          preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "warning"
          }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningWeekLabel",
            defaultMessage: "Consider using the d unit instead of w. This allows for more flexible queries."
          })));
          break;
      }
    } catch (error) {
      // Swallow error; the validation logic will handle it elsewhere.
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, preferFixedWarning, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.helpExampleLabel",
      defaultMessage: "Example sizes: 1000ms, 30s, 20m, 24h, 2d, 1w, 1M, 1y"
    })));
  }
  render() {
    const {
      fields,
      onFieldsChange,
      areStepErrorsVisible,
      fieldErrors
    } = this.props;
    const {
      dateHistogramInterval,
      dateHistogramField,
      dateHistogramTimeZone
    } = fields;
    const {
      dateHistogramInterval: errorDateHistogramInterval,
      dateHistogramField: errorDateHistogramField,
      dateHistogramTimeZone: errorDateHistogramTimeZone
    } = fieldErrors;
    const {
      dateHistogramFieldOptions
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "rollupJobCreateDateHistogramTitle"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepDateHistogramTitle",
      defaultMessage: "Date histogram"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: _documentation_links.documentationLinks.apis.createRollupJobsRequest,
      target: "_blank",
      iconType: "help",
      "data-test-subj": "rollupJobCreateDateHistogramDocsButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepDateHistogram.readDocsButtonLabel",
      defaultMessage: "Date histogram docs"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement("div", null),
      description: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogramDescription",
        defaultMessage: "Define how {link} will operate on your rollup data.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _documentation_links.documentationLinks.aggs.date_histogram,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.stepDateHistogramDescription.aggregationsLinkLabel",
            defaultMessage: "date histogram aggregations"
          }))
        }
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.sectionDataSourceDescription",
        defaultMessage: "Note that smaller time buckets take up proportionally more space."
      }))),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldDateFieldLabel",
        defaultMessage: "Date field"
      }),
      error: errorDateHistogramField,
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramField),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramField),
      options: dateHistogramFieldOptions,
      value: dateHistogramField,
      onChange: e => onFieldsChange({
        dateHistogramField: e.target.value
      }),
      fullWidth: true,
      "data-test-subj": "rollupJobCreateDateFieldSelect"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldIntervalLabel",
        defaultMessage: "Time bucket size"
      }),
      error: errorDateHistogramInterval,
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramInterval),
      helpText: this.renderIntervalHelpText(),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: dateHistogramInterval || '',
      onChange: e => onFieldsChange({
        dateHistogramInterval: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramInterval),
      fullWidth: true,
      "data-test-subj": "rollupJobInterval"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldTimeZoneLabel",
        defaultMessage: "Time zone"
      }),
      error: errorDateHistogramTimeZone || '',
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramTimeZone),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: timeZoneOptions,
      value: dateHistogramTimeZone,
      onChange: e => onFieldsChange({
        dateHistogramTimeZone: e.target.value
      }),
      fullWidth: true,
      "data-test-subj": "rollupJobCreateTimeZoneSelect"
    })))), this.renderErrors());
  }
}
exports.StepDateHistogram = StepDateHistogram;
(0, _defineProperty2.default)(StepDateHistogram, "propTypes", {
  fields: _propTypes.default.object.isRequired,
  onFieldsChange: _propTypes.default.func.isRequired,
  fieldErrors: _propTypes.default.object.isRequired,
  hasErrors: _propTypes.default.bool.isRequired,
  areStepErrorsVisible: _propTypes.default.bool.isRequired,
  dateFields: _propTypes.default.array.isRequired
});