"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobManagementPreRouting = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _i18n = require("@kbn/i18n");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Handles the common parts of requests to manage (view, download and delete) reports
 */
const jobManagementPreRouting = async (reporting, res, docId, user, counters, cb) => {
  const licenseInfo = await reporting.getLicenseInfo();
  const {
    management: {
      jobTypes = []
    }
  } = licenseInfo;
  const jobsQuery = (0, _.jobsQueryFactory)(reporting);
  const doc = await jobsQuery.get(user, docId);
  if (!doc) {
    return res.notFound();
  }
  const {
    jobtype
  } = doc;
  if (!jobTypes.includes(jobtype)) {
    return res.forbidden({
      body: _i18n.i18n.translate('xpack.reporting.jobResponse.errorHandler.notAuthorized', {
        defaultMessage: `Sorry, you are not authorized to view or delete {jobtype} reports`,
        values: {
          jobtype
        }
      })
    });
  }

  // Count usage once allowing the request
  counters.usageCounter(jobtype);
  try {
    return await cb(doc);
  } catch (err) {
    const {
      logger
    } = reporting.getPluginSetupDeps();
    logger.error(err);
    if (err instanceof _boom.default.Boom) {
      const statusCode = err.output.statusCode;
      counters === null || counters === void 0 ? void 0 : counters.errorCounter(jobtype, statusCode);
      return res.customError({
        statusCode,
        body: err.output.payload.message
      });
    }
    counters === null || counters === void 0 ? void 0 : counters.errorCounter(jobtype, 500);
    return res.customError({
      statusCode: 500,
      body: (err === null || err === void 0 ? void 0 : err.message) || _i18n.i18n.translate('xpack.reporting.jobResponse.errorHandler.unknownError', {
        defaultMessage: 'Unknown error'
      })
    });
  }
};
exports.jobManagementPreRouting = jobManagementPreRouting;