"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWarningToast = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _job_download_button = require("./job_download_button");
var _report_link = require("./report_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWarningToast = (job, getReportLink, getDownloadLink, theme) => ({
  title: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.reporting.publicNotifier.warning.title",
    defaultMessage: "{reportType} completed with issues",
    values: {
      reportType: job.jobtype
    }
  }), {
    theme$: theme.theme$
  }),
  text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_report_link.ReportLink, {
    getUrl: getReportLink
  })), /*#__PURE__*/_react.default.createElement(_job_download_button.DownloadButton, {
    getUrl: getDownloadLink,
    job: job
  })), {
    theme$: theme.theme$
  }),
  'data-test-subj': 'completeReportWarning'
});
exports.getWarningToast = getWarningToast;