"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmPolicyMigrationNeededCallOut = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _reporting_api_client = require("../../../lib/reporting_api_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  title: _i18n.i18n.translate('xpack.reporting.listing.ilmPolicyCallout.migrationNeededTitle', {
    defaultMessage: 'Apply new lifecycle policy for reports'
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.reporting.listing.ilmPolicyCallout.migrationNeededDescription",
    defaultMessage: "To ensure your reports are managed consistently, all reporting indices should use the {ilmPolicyName} policy.",
    values: {
      ilmPolicyName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _constants.ILM_POLICY_NAME)
    }
  }),
  buttonLabel: _i18n.i18n.translate('xpack.reporting.listing.ilmPolicyCallout.migrateIndicesButtonLabel', {
    defaultMessage: 'Apply {ilmPolicyName} policy',
    values: {
      ilmPolicyName: _constants.ILM_POLICY_NAME
    }
  }),
  migrateErrorTitle: _i18n.i18n.translate('xpack.reporting.listing.ilmPolicyCallout.migrateIndicesErrorTitle', {
    defaultMessage: 'Could not migrate reporting indices'
  }),
  migrateSuccessTitle: _i18n.i18n.translate('xpack.reporting.listing.ilmPolicyCallout.migrateIndicesSuccessTitle', {
    defaultMessage: 'Reporting policy active for all reporting indices'
  })
};
const IlmPolicyMigrationNeededCallOut = ({
  toasts,
  onMigrationDone
}) => {
  const [isMigratingIndices, setIsMigratingIndices] = (0, _react.useState)(false);
  const isMounted = (0, _useMountedState.default)();
  const {
    apiClient
  } = (0, _reporting_api_client.useInternalApiClient)();
  const migrateReportingIndices = async () => {
    try {
      setIsMigratingIndices(true);
      await apiClient.migrateReportingIndicesIlmPolicy();
      onMigrationDone();
      toasts.addSuccess({
        title: i18nTexts.migrateSuccessTitle
      });
    } catch (e) {
      var _e$body;
      toasts.addError(e, {
        title: i18nTexts.migrateErrorTitle,
        toastMessage: (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message
      });
    } finally {
      if (isMounted()) setIsMigratingIndices(false);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "migrateReportingIndicesPolicyCallOut",
    title: i18nTexts.title
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.description), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "migrateReportingIndicesButton",
    isLoading: isMigratingIndices,
    onClick: migrateReportingIndices
  }, i18nTexts.buttonLabel));
};
exports.IlmPolicyMigrationNeededCallOut = IlmPolicyMigrationNeededCallOut;