"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportTypesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ExportTypesPlugin {
  constructor(initializerContext, logger) {
    (0, _defineProperty2.default)(this, "exportTypes", [
      // new CsvExportType(),
      // new PdfExportType(),
      // new PngExportType(),
    ]);
    logger = initializerContext.logger.get();
  }
  setup(core, pluginsSetup) {
    const {
      reporting
    } = pluginsSetup;
    this.exportTypes.forEach(eType => {
      reporting.registerExportTypes(eType);
    });
    return {};
  }
  start(core, plugins) {
    this.exportTypes.forEach(eType => {});
    return {};
  }
  stop() {}
}
exports.ExportTypesPlugin = ExportTypesPlugin;