"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editCluster = editCluster;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  clusterName: undefined,
  isEditing: false,
  error: undefined
};
function editCluster(state = initialState, action) {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case _action_types.EDIT_CLUSTER_START:
      const {
        clusterName
      } = payload;
      return {
        clusterName
      };
    case _action_types.EDIT_CLUSTER_STOP:
      return {
        clusterName: undefined,
        isEditing: false,
        error: undefined
      };
    case _action_types.EDIT_CLUSTER_SAVE:
      return {
        ...state,
        isEditing: true
      };
    case _action_types.EDIT_CLUSTER_SUCCESS:
      return {
        ...state,
        isEditing: false
      };
    case _action_types.EDIT_CLUSTER_FAILURE:
      return {
        ...state,
        error: payload.error,
        isEditing: false
      };
    case _action_types.CLEAR_EDIT_CLUSTER_ERRORS:
      return {
        ...state,
        error: undefined
      };
    default:
      return state;
  }
}