"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "METRIC_TYPE", {
  enumerable: true,
  get: function () {
    return _analytics.METRIC_TYPE;
  }
});
exports.init = init;
exports.trackUiMetric = trackUiMetric;
exports.trackUserRequest = trackUserRequest;
exports.usageCollection = void 0;
var _analytics = require("@kbn/analytics");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let usageCollection;
exports.usageCollection = usageCollection;
function init(_usageCollection) {
  exports.usageCollection = usageCollection = _usageCollection;
}
function trackUiMetric(metricType, name) {
  if (!usageCollection) {
    return;
  }
  const {
    reportUiCounter
  } = usageCollection;
  reportUiCounter(_constants.UIM_APP_NAME, metricType, name);
}

/**
 * Transparently return provided request Promise, while allowing us to track
 * a successful completion of the request.
 */
function trackUserRequest(request, eventName) {
  // Only track successful actions.
  return request.then(response => {
    trackUiMetric(_analytics.METRIC_TYPE.COUNT, eventName);
    // We return the response immediately without waiting for the tracking request to resolve,
    // to avoid adding additional latency.
    return response;
  });
}