"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudUrlHelp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CloudUrlHelp = () => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const {
    cloudBaseUrl
  } = (0, _app_context.useAppContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setIsOpen(!isOpen);
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloudUrlHelp.buttonLabel",
      defaultMessage: "Need help?"
    }))),
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    anchorPosition: "upCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.remoteClusterForm.cloudUrlHelp.popoverTitle",
    defaultMessage: "How to find your Elasticsearch endpoint URL"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      maxWidth: 500
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.remoteClusterForm.cloudUrlHelp.stepOneText",
    defaultMessage: "Open the {deploymentsLink}, select the remote deployment and copy the {elasticsearch} endpoint URL.",
    values: {
      deploymentsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: `${cloudBaseUrl}/deployments`,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.cloudUrlHelpModal.deploymentsLink",
        defaultMessage: "deployments page"
      })),
      elasticsearch: /*#__PURE__*/_react.default.createElement("strong", null, " Elasticsearch")
    }
  })));
};
exports.CloudUrlHelp = CloudUrlHelp;