"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableResourceManagement = enableResourceManagement;
exports.setMaximumBuckets = setMaximumBuckets;
exports.validateMaximumBuckets = validateMaximumBuckets;
exports.validateResourceManagement = validateResourceManagement;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_BUCKETS = 150000;
async function validateMaximumBuckets({
  client
}) {
  var _settings$persistent$;
  const settings = await client.getEsClient().cluster.getSettings({});
  const maxBuckets = (_settings$persistent$ = settings.persistent.search) === null || _settings$persistent$ === void 0 ? void 0 : _settings$persistent$.max_buckets;
  return {
    settings: {
      configured: maxBuckets === MAX_BUCKETS.toString()
    }
  };
}
async function setMaximumBuckets({
  client
}) {
  await client.getEsClient().cluster.putSettings({
    persistent: {
      search: {
        max_buckets: MAX_BUCKETS
      }
    }
  });
}
async function validateResourceManagement({
  client
}) {
  const statusResponse = await client.profilingStatus();
  return {
    resource_management: {
      enabled: statusResponse.resource_management.enabled
    },
    resources: {
      created: statusResponse.resources.created
    }
  };
}
async function enableResourceManagement({
  client
}) {
  await client.getEsClient().cluster.putSettings({
    persistent: {
      xpack: {
        profiling: {
          templates: {
            enabled: true
          }
        }
      }
    }
  });
}