"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackTracesView = StackTracesView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _stack_traces = require("../../../common/stack_traces");
var _topn = require("../../../common/topn");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _use_time_range = require("../../hooks/use_time_range");
var _use_time_range_async = require("../../hooks/use_time_range_async");
var _async_component = require("../../components/async_component");
var _chart_grid = require("../../components/chart_grid");
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
var _stacked_bar_chart = require("../../components/stacked_bar_chart");
var _get_stack_traces_tabs = require("./get_stack_traces_tabs");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StackTracesView() {
  var _data$charts, _data$charts2, _data$charts$length;
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const {
    path,
    query,
    path: {
      topNType
    },
    query: {
      rangeFrom,
      rangeTo,
      kuery,
      displayAs,
      limit: limitFromQueryParams
    }
  } = (0, _use_profiling_params.useProfilingParams)('/stacktraces/{topNType}');
  const limit = limitFromQueryParams || 10;
  const tabs = (0, _get_stack_traces_tabs.getStackTracesTabs)({
    path,
    query,
    profilingRouter
  });
  const {
    services: {
      fetchTopN
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    if (!topNType) {
      return Promise.resolve({
        charts: [],
        metadata: {}
      });
    }
    return fetchTopN({
      http,
      type: topNType,
      timeFrom: timeRange.inSeconds.start,
      timeTo: timeRange.inSeconds.end,
      kuery
    }).then(response => {
      const totalCount = response.TotalCount;
      const samples = response.TopN;
      const charts = (0, _topn.groupSamplesByCategory)({
        samples,
        totalCount,
        metadata: response.Metadata,
        labels: response.Labels
      });
      return {
        charts
      };
    });
  }, [topNType, timeRange.inSeconds.start, timeRange.inSeconds.end, fetchTopN, kuery]);
  const {
    data
  } = state;
  function onStackedBarClick(category) {
    profilingRouter.push('/stacktraces/{topNType}', (0, _utils.getTracesViewRouteParams)({
      query,
      topNType: path.topNType,
      category
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    tabs: tabs
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    idSelected: displayAs,
    type: "single",
    onChange: nextValue => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          displayAs: nextValue
        }
      });
    },
    options: [{
      id: _stack_traces.StackTracesDisplayOption.StackTraces,
      iconType: 'visLine',
      label: _i18n.i18n.translate('xpack.profiling.stackTracesView.stackTracesCountButton', {
        defaultMessage: 'Stack traces'
      })
    }, {
      id: _stack_traces.StackTracesDisplayOption.Percentage,
      iconType: 'percent',
      label: _i18n.i18n.translate('xpack.profiling.stackTracesView.percentagesButton', {
        defaultMessage: 'Percentages'
      })
    }],
    legend: _i18n.i18n.translate('xpack.profiling.stackTracesView.displayOptionLegend', {
      defaultMessage: 'Display option'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({
    size: "xl"
  }, state, {
    style: {
      height: 400
    }
  }), /*#__PURE__*/_react.default.createElement(_stacked_bar_chart.StackedBarChart, {
    height: 400,
    charts: (_data$charts = data === null || data === void 0 ? void 0 : data.charts) !== null && _data$charts !== void 0 ? _data$charts : [],
    asPercentages: displayAs === _stack_traces.StackTracesDisplayOption.Percentage,
    onBrushEnd: nextRange => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          rangeFrom: nextRange.rangeFrom,
          rangeTo: nextRange.rangeTo
        }
      });
    },
    showFrames: topNType === _stack_traces.TopNType.Traces,
    onClick: topNType === _stack_traces.TopNType.Threads ? onStackedBarClick : undefined
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({
    size: "m",
    mono: true
  }, state, {
    style: {
      minHeight: 200
    }
  }), /*#__PURE__*/_react.default.createElement(_chart_grid.ChartGrid, {
    charts: (_data$charts2 = data === null || data === void 0 ? void 0 : data.charts) !== null && _data$charts2 !== void 0 ? _data$charts2 : [],
    limit: limit,
    showFrames: topNType === _stack_traces.TopNType.Traces
  }))), ((_data$charts$length = data === null || data === void 0 ? void 0 : data.charts.length) !== null && _data$charts$length !== void 0 ? _data$charts$length : 0) > limit && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          limit: limit + 10
        }
      });
    }
  }, _i18n.i18n.translate('xpack.profiling.stackTracesView.showMoreButton', {
    defaultMessage: 'Show more'
  })))));
}