"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DifferentialTopNFunctionsView = DifferentialTopNFunctionsView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _normalization_menu = require("../../../components/normalization_menu");
var _primary_and_comparison_search_bar = require("../../../components/primary_and_comparison_search_bar");
var _topn_functions = require("../../../components/topn_functions");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../../hooks/use_profiling_route_path");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DifferentialTopNFunctionsView() {
  const {
    path,
    query,
    query: {
      rangeFrom,
      rangeTo,
      kuery,
      sortDirection,
      sortField,
      comparisonKuery,
      normalizationMode,
      comparisonRangeFrom,
      comparisonRangeTo,
      baseline = 1,
      comparison = 1
    }
  } = (0, _use_profiling_params.useProfilingParams)('/functions/differential');
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonTimeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom: comparisonRangeFrom,
    rangeTo: comparisonRangeTo,
    optional: true
  });
  const totalSeconds = timeRange.inSeconds.end - timeRange.inSeconds.start;
  const totalComparisonSeconds = (new Date(comparisonTimeRange.end).getTime() - new Date(comparisonTimeRange.start).getTime()) / 1000;
  const comparisonTime = totalSeconds / totalComparisonSeconds;
  const baselineTime = 1;
  const normalizationOptions = {
    baselineScale: baseline,
    baselineTime,
    comparisonScale: comparison,
    comparisonTime
  };
  const {
    services: {
      fetchTopNFunctions
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchTopNFunctions({
      http,
      timeFrom: timeRange.inSeconds.start,
      timeTo: timeRange.inSeconds.end,
      startIndex: 0,
      endIndex: 100000,
      kuery
    });
  }, [timeRange.inSeconds.start, timeRange.inSeconds.end, kuery, fetchTopNFunctions]);
  const comparisonState = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    if (!comparisonTimeRange.inSeconds.start || !comparisonTimeRange.inSeconds.end) {
      return undefined;
    }
    return fetchTopNFunctions({
      http,
      timeFrom: comparisonTimeRange.inSeconds.start,
      timeTo: comparisonTimeRange.inSeconds.end,
      startIndex: 0,
      endIndex: 100000,
      kuery: comparisonKuery
    });
  }, [comparisonTimeRange.inSeconds.start, comparisonTimeRange.inSeconds.end, comparisonKuery, fetchTopNFunctions]);
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  function onChangeNormalizationMode(nextNormalizationMode, options) {
    profilingRouter.push(routePath, {
      path: routePath,
      query: nextNormalizationMode === _normalization_menu.NormalizationMode.Scale ? {
        ...query,
        baseline: options.baselineScale,
        comparison: options.comparisonScale,
        normalizationMode: nextNormalizationMode
      } : {
        ...query,
        normalizationMode: nextNormalizationMode
      }
    });
  }
  const isNormalizedByTime = normalizationMode === _normalization_menu.NormalizationMode.Time;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_primary_and_comparison_search_bar.PrimaryAndComparisonSearchBar, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_normalization_menu.NormalizationMenu, {
    mode: normalizationMode,
    options: normalizationOptions,
    onChange: onChangeNormalizationMode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, state, {
    size: "xl",
    alignTop: true
  }), /*#__PURE__*/_react.default.createElement(_topn_functions.TopNFunctionsTable, {
    topNFunctions: state.data,
    sortDirection: sortDirection,
    sortField: sortField,
    onSortChange: nextSort => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          sortField: nextSort.sortField,
          sortDirection: nextSort.sortDirection
        }
      });
    },
    totalSeconds: timeRange.inSeconds.end - timeRange.inSeconds.start,
    isDifferentialView: true,
    baselineScaleFactor: isNormalizedByTime ? baselineTime : baseline
  }))), comparisonTimeRange.inSeconds.start && comparisonTimeRange.inSeconds.end ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, comparisonState, {
    size: "xl",
    alignTop: true
  }), /*#__PURE__*/_react.default.createElement(_topn_functions.TopNFunctionsTable, {
    sortDirection: sortDirection,
    sortField: sortField,
    onSortChange: nextSort => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          sortField: nextSort.sortField,
          sortDirection: nextSort.sortDirection
        }
      });
    },
    topNFunctions: comparisonState.data,
    comparisonTopNFunctions: state.data,
    totalSeconds: comparisonTimeRange.inSeconds.end - comparisonTimeRange.inSeconds.start,
    isDifferentialView: true,
    baselineScaleFactor: isNormalizedByTime ? comparisonTime : comparison,
    comparisonScaleFactor: isNormalizedByTime ? baselineTime : baseline
  }))) : null))));
}