"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackFrameSummary = StackFrameSummary;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _profiling = require("../../common/profiling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StackFrameSummary({
  frame
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      fontWeight: 'bold',
      overflowWrap: 'anywhere'
    }
  }, (0, _profiling.getCalleeFunction)(frame)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      overflowWrap: 'anywhere'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, (0, _profiling.getCalleeSource)(frame) || '‎')));
}