"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectWithDefaultDateRange = RedirectWithDefaultDateRange;
var _use_default_date_range_redirect = require("../hooks/use_default_date_range_redirect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RedirectWithDefaultDateRange({
  children
}) {
  const {
    redirect,
    isDateRangeSet,
    skipDataRangeSet
  } = (0, _use_default_date_range_redirect.useDateRangeRedirect)();
  if (isDateRangeSet || skipDataRangeSet) {
    return children;
  }
  redirect();
  return null;
}