"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingSymbolsCallout = MissingSymbolsCallout;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _profiling = require("../../../common/profiling");
var _profiling_app_page_template = require("../profiling_app_page_template");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _no_data_view = require("../../views/no_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MissingSymbolsCallout({
  frameType
}) {
  const languageType = (0, _profiling.getLanguageType)({
    frameType
  });
  const router = (0, _use_profiling_router.useProfilingRouter)();
  const {
    docLinks
  } = (0, _use_profiling_dependencies.useProfilingDependencies)().start.core;
  if (languageType === 'NATIVE') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.native.title', {
        defaultMessage: 'Missing symbols'
      }),
      color: "warning",
      iconType: "help"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.profiling.frameInformationWindow.missingSymbols.native",
      defaultMessage: "To see function names and line numbers in traces of applications written in programming languages that compile to native code (C, C++, Rust, Go, etc.), you need to push symbols to the cluster using the elastic-profiling binary. {readMore}, or download the binary below.",
      values: {
        readMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: `${docLinks.ELASTIC_WEBSITE_URL}/guide/en/observability/${docLinks.DOC_LINK_VERSION}/profiling-add-symbols.html`,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.native.readMore', {
          defaultMessage: 'Read more'
        }))
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: router.link('/add-data-instructions', {
        query: {
          selectedTab: _no_data_view.NoDataTabs.Symbols
        }
      }),
      color: "warning"
    }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.native.downloadBinary', {
      defaultMessage: 'Upload Symbols'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.interpreted.title', {
      defaultMessage: 'Missing symbols error'
    }),
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.interpreted', {
    defaultMessage: 'Symbols are not available because of an error in the unwinder for this language or an unknown error with the interpreter.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: _profiling_app_page_template.PROFILING_FEEDBACK_LINK,
    target: "_blank",
    color: "warning"
  }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.interpreted.reportProblem', {
    defaultMessage: 'Report a problem'
  })));
}