"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrameInformationWindow = FrameInformationWindow;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _profiling = require("../../../common/profiling");
var _frame_information_panel = require("./frame_information_panel");
var _get_impact_rows = require("./get_impact_rows");
var _get_information_rows = require("./get_information_rows");
var _key_value_list = require("./key_value_list");
var _missing_symbols_callout = require("./missing_symbols_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FrameInformationWindow({
  frame,
  totalSamples,
  totalSeconds,
  samplingRate
}) {
  const coPilotService = (0, _public.useCoPilot)();
  const promptParams = (0, _react.useMemo)(() => {
    return frame !== null && frame !== void 0 && frame.functionName && frame !== null && frame !== void 0 && frame.exeFileName ? {
      functionName: frame === null || frame === void 0 ? void 0 : frame.functionName,
      library: frame === null || frame === void 0 ? void 0 : frame.exeFileName
    } : undefined;
  }, [frame === null || frame === void 0 ? void 0 : frame.functionName, frame === null || frame === void 0 ? void 0 : frame.exeFileName]);
  if (!frame) {
    return /*#__PURE__*/_react.default.createElement(_frame_information_panel.FrameInformationPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.selectFrame', {
      defaultMessage: 'Click on a frame to display more information'
    })));
  }
  const symbolStatus = (0, _profiling.getFrameSymbolStatus)({
    sourceFilename: frame.sourceFileName,
    sourceLine: frame.sourceLine,
    exeFileName: frame.exeFileName
  });
  const {
    fileID,
    frameType,
    exeFileName,
    addressOrLine,
    functionName,
    sourceFileName,
    sourceLine,
    countInclusive,
    countExclusive
  } = frame;
  const informationRows = (0, _get_information_rows.getInformationRows)({
    fileID,
    frameType,
    exeFileName,
    addressOrLine,
    functionName,
    sourceFileName,
    sourceLine
  });

  // Are the results sampled? If yes, prepend a '~'.
  const isApproximate = (samplingRate !== null && samplingRate !== void 0 ? samplingRate : 1.0) === 1.0;
  const prependString = isApproximate ? undefined : '~';
  const impactRows = (0, _get_impact_rows.getImpactRows)({
    countInclusive,
    countExclusive,
    totalSamples,
    totalSeconds,
    isApproximate
  });
  return /*#__PURE__*/_react.default.createElement(_frame_information_panel.FrameInformationPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_key_value_list.KeyValueList, {
    rows: informationRows
  })), coPilotService !== null && coPilotService !== void 0 && coPilotService.isEnabled() && promptParams ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.CoPilotPrompt, {
    coPilot: coPilotService,
    promptId: _common.CoPilotPromptId.ProfilingOptimizeFunction,
    params: promptParams,
    title: _i18n.i18n.translate('xpack.profiling.frameInformationWindow.optimizeFunction', {
      defaultMessage: 'Optimize function'
    }),
    feedbackEnabled: true
  }))) : undefined, symbolStatus !== _profiling.FrameSymbolStatus.SYMBOLIZED && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_missing_symbols_callout.MissingSymbolsCallout, {
    frameType: frame.frameType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.impactEstimatesTitle', {
    defaultMessage: 'Impact estimates'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_key_value_list.KeyValueList, {
    rows: impactRows,
    prependString: prependString
  }))))));
}