"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setUISettingsStatus = exports.setStorageStatus = exports.isEnabledByStorageValue = exports.applyProjectStatus = void 0;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isEnabledByStorageValue = (project, environment, value) => {
  const defaultValue = project.isActive;
  if (!project.environments.includes(environment)) {
    return defaultValue;
  }
  if (value === true || value === false) {
    return value;
  }
  if (value === 'enabled') {
    return true;
  }
  if (value === 'disabled') {
    return false;
  }
  return defaultValue;
};
exports.isEnabledByStorageValue = isEnabledByStorageValue;
const setStorageStatus = (storage, id, enabled) => storage.setItem(id, enabled ? 'enabled' : 'disabled');
exports.setStorageStatus = setStorageStatus;
const applyProjectStatus = (project, status) => {
  const {
    isActive,
    environments
  } = project;
  _common.environmentNames.forEach(name => {
    if (!environments.includes(name)) {
      delete status[name];
    }
  });
  const isEnabled = (0, _common.isProjectEnabledByStatus)(isActive, status);
  const isOverride = isEnabled !== isActive;
  return {
    ...project,
    status: {
      ...status,
      defaultValue: isActive,
      isEnabled,
      isOverride
    }
  };
};
exports.applyProjectStatus = applyProjectStatus;
const setUISettingsStatus = (client, id, enabled) => client.set(id, enabled);
exports.setUISettingsStatus = setUISettingsStatus;