"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardsServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardsServiceFactory = ({
  coreStart
}) => {
  const findDashboards = async (query = '', fields = []) => {
    const {
      find
    } = coreStart.savedObjects.client;
    const {
      savedObjects
    } = await find({
      type: 'dashboard',
      search: `${query}*`,
      searchFields: fields
    });
    return savedObjects;
  };
  const findDashboardsByTitle = async (title = '') => findDashboards(title, ['title']);
  return {
    findDashboards,
    findDashboardsByTitle
  };
};
exports.dashboardsServiceFactory = dashboardsServiceFactory;