"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateContainsFilters = exports.cleanStateForRedux = exports.cleanInputForRedux = exports.cleanFiltersForSerialize = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// TODO: Make filters serializable so we don't need special treatment for them.

const stateContainsFilters = state => {
  if (state.filters && state.filters.length > 0) return true;
  return false;
};
exports.stateContainsFilters = stateContainsFilters;
const cleanFiltersForSerialize = filters => {
  if (!filters) return [];
  return filters.map(filter => {
    if (filter.meta.value) delete filter.meta.value;
    return filter;
  });
};
exports.cleanFiltersForSerialize = cleanFiltersForSerialize;
const cleanInputForRedux = explicitInput => {
  if (stateContainsFilters(explicitInput)) {
    explicitInput.filters = cleanFiltersForSerialize(explicitInput.filters);
  }
  return explicitInput;
};
exports.cleanInputForRedux = cleanInputForRedux;
const cleanStateForRedux = state => {
  // clean explicit input
  state.explicitInput = cleanInputForRedux(state.explicitInput);
  return state;
};
exports.cleanStateForRedux = cleanStateForRedux;