"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverridenCount = exports.default = exports.LabsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _services = require("../../services");
var _i18n = require("../../i18n");
var _project_list = require("./project_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  Flyout: strings
} = _i18n.LabsStrings.Components;
const hasStatusChanged = (original, current) => {
  for (const id of Object.keys(original)) {
    for (const key of Object.keys(original[id].status)) {
      if (original[id].status[key] !== current[id].status[key]) {
        return true;
      }
    }
  }
  return false;
};
const getOverridenCount = projects => Object.values(projects).filter(project => project.status.isOverride).length;
exports.getOverridenCount = getOverridenCount;
const LabsFlyout = props => {
  const {
    solutions,
    onEnabledCountChange = () => {},
    onClose
  } = props;
  const {
    labs: labsService
  } = _services.pluginServices.getHooks();
  const {
    getProjects,
    setProjectStatus,
    reset
  } = labsService.useService();
  const [projects, setProjects] = (0, _react.useState)(getProjects());
  const [overrideCount, setOverrideCount] = (0, _react.useState)(getOverridenCount(projects));
  const initialStatus = (0, _react.useRef)(getProjects());
  const isChanged = hasStatusChanged(initialStatus.current, projects);
  (0, _react.useEffect)(() => {
    setOverrideCount(getOverridenCount(projects));
  }, [projects]);
  (0, _react.useEffect)(() => {
    onEnabledCountChange(overrideCount);
  }, [onEnabledCountChange, overrideCount]);
  const onStatusChange = (id, env, enabled) => {
    setProjectStatus(id, env, enabled);
    setProjects(getProjects());
  };
  let footer = null;
  const resetButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      reset();
      setProjects(getProjects());
    },
    isDisabled: !overrideCount
  }, strings.getResetToDefaultLabel());
  const refreshButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: () => {
      window.location.reload();
    },
    isDisabled: !isChanged
  }, strings.getRefreshLabel());
  footer = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => onClose(),
    flush: "left"
  }, strings.getCloseButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, resetButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, refreshButton)))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    hideCloseButton: true,
    maskProps: {
      headerZindexLocation: 'below'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "beaker",
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, strings.getTitleLabel())))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, strings.getDescriptionMessage()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_project_list.ProjectList, {
    projects,
    solutions,
    onStatusChange
  })), footer);
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.LabsFlyout = LabsFlyout;
var _default = LabsFlyout;
exports.default = _default;