"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OsqueryAction = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _prompts = require("../prompts");
var _translations = require("./translations");
var _kibana = require("../../common/lib/kibana");
var _live_queries = require("../../live_queries");
var _osquery_icon = require("../../components/osquery_icon");
var _use_is_osquery_available = require("../use_is_osquery_available");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryActionComponent = ({
  agentId,
  formType = 'simple',
  defaultValues,
  hideAgentsField,
  onSuccess
}) => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const {
    osqueryAvailable,
    agentFetched,
    isLoading,
    policyFetched,
    policyLoading,
    agentData
  } = (0, _use_is_osquery_available.useIsOsqueryAvailable)(agentId);
  if (agentId && agentFetched && !agentData) {
    return /*#__PURE__*/_react.default.createElement(_prompts.OsqueryEmptyPrompt, null);
  }
  if ((!permissions.runSavedQueries || !permissions.readSavedQueries) && !permissions.writeLiveQueries) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, null),
      title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.PERMISSION_DENIED),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.osquery.action.missingPrivileges",
        defaultMessage: "To access this page, ask your administrator for {osquery} Kibana privileges."
        // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
        ,
        values: {
          osquery: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "osquery")
        }
      }))
    });
  }
  if (agentId && isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10
    });
  }
  if (agentId && !policyFetched && policyLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10
    });
  }
  if (agentId && !osqueryAvailable) {
    return /*#__PURE__*/_react.default.createElement(_prompts.OsqueryNotAvailablePrompt, null);
  }
  if (agentId && (agentData === null || agentData === void 0 ? void 0 : agentData.status) !== 'online') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, null),
      title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.SHORT_EMPTY_TITLE),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", null, _translations.AGENT_STATUS_ERROR)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_live_queries.LiveQuery, (0, _extends2.default)({
    formType: formType,
    agentId: agentId,
    hideAgentsField: hideAgentsField,
    onSuccess: onSuccess
  }, defaultValues));
};
OsqueryActionComponent.displayName = 'OsqueryAction';
const OsqueryAction = /*#__PURE__*/_react.default.memo(OsqueryActionComponent);

// eslint-disable-next-line import/no-default-export
exports.default = exports.OsqueryAction = OsqueryAction;