"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedQueryForm = exports.savedQueryDataSerializer = void 0;
var _reactHookForm = require("react-hook-form");
var _lodash = require("lodash");
var _immer = _interopRequireDefault(require("immer"));
var _react = require("react");
var _use_saved_queries = require("../use_saved_queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deserializer = payload => {
  var _payload$snapshot, _payload$removed;
  return {
    id: payload.id,
    description: payload.description,
    query: payload.query,
    interval: payload.interval ? parseInt(payload.interval, 10) : 3600,
    snapshot: (_payload$snapshot = payload.snapshot) !== null && _payload$snapshot !== void 0 ? _payload$snapshot : true,
    removed: (_payload$removed = payload.removed) !== null && _payload$removed !== void 0 ? _payload$removed : false,
    platform: payload.platform,
    version: payload.version ? [payload.version] : [],
    ecs_mapping: !(0, _lodash.isEmpty)(payload.ecs_mapping) ? payload.ecs_mapping : {}
  };
};
const savedQueryDataSerializer = payload =>
// @ts-expect-error update types
(0, _immer.default)(payload, draft => {
  if ((0, _lodash.isArray)(draft.version)) {
    if (!draft.version.length) {
      draft.version = '';
    } else {
      draft.version = draft.version[0];
    }
  }
  if ((0, _lodash.isArray)(draft.platform) && !draft.platform.length) {
    delete draft.platform;
  }
  if (draft.interval) {
    draft.interval = draft.interval + '';
  }
  return draft;
});
exports.savedQueryDataSerializer = savedQueryDataSerializer;
const useSavedQueryForm = ({
  defaultValue
}) => {
  const {
    data
  } = (0, _use_saved_queries.useSavedQueries)({});
  const ids = (0, _react.useMemo)(() => {
    var _map;
    return (_map = (0, _lodash.map)(data === null || data === void 0 ? void 0 : data.data, 'id')) !== null && _map !== void 0 ? _map : [];
  }, [data]);
  const idSet = (0, _react.useMemo)(() => {
    const res = new Set(ids);
    if (defaultValue && defaultValue.id) res.delete(defaultValue.id);
    return res;
  }, [ids, defaultValue]);
  return {
    serializer: savedQueryDataSerializer,
    idSet,
    ...(0, _reactHookForm.useForm)({
      defaultValues: defaultValue ? deserializer(defaultValue) : {
        id: '',
        query: '',
        interval: 3600,
        ecs_mapping: {},
        snapshot: true
      }
    })
  };
};
exports.useSavedQueryForm = useSavedQueryForm;