"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LiveQueryQueryField = void 0;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _editor = require("../../editor");
var _kibana = require("../../common/lib/kibana");
var _lazy_ecs_mapping_editor_field = require("../../packs/queries/lazy_ecs_mapping_editor_field");
var _saved_queries_dropdown = require("../../saved_queries/saved_queries_dropdown");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  ${({
  isDisabled
}) => isDisabled && 'display: none;'}
  .euiAccordion__button {
    color: ${({
  theme
}) => theme.eui.euiColorPrimary};
  }
  .euiAccordion__childWrapper {
    -webkit-transition: none;
  }
`;
const StyledEuiCodeBlock = (0, _styledComponents.default)(_eui.EuiCodeBlock)`
  min-height: 100px;
`;
const LiveQueryQueryFieldComponent = ({
  disabled,
  handleSubmitForm
}) => {
  const {
    formState,
    watch,
    resetField
  } = (0, _reactHookForm.useFormContext)();
  const [advancedContentState, setAdvancedContentState] = (0, _react.useState)(() => {
    var _formState$defaultVal;
    return (0, _lodash.isEmpty)((_formState$defaultVal = formState.defaultValues) === null || _formState$defaultVal === void 0 ? void 0 : _formState$defaultVal.ecs_mapping) ? 'closed' : 'open';
  });
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const [queryType] = watch(['queryType']);
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'query',
    rules: {
      required: {
        message: _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.emptyQueryError', {
          defaultMessage: 'Query is a required field'
        }),
        value: queryType !== 'pack'
      }
    },
    defaultValue: ''
  });
  const handleSavedQueryChange = (0, _react.useCallback)(savedQuery => {
    if (savedQuery) {
      var _savedQuery$ecs_mappi;
      resetField('query', {
        defaultValue: savedQuery.query
      });
      resetField('savedQueryId', {
        defaultValue: savedQuery.savedQueryId
      });
      resetField('ecs_mapping', {
        defaultValue: (_savedQuery$ecs_mappi = savedQuery.ecs_mapping) !== null && _savedQuery$ecs_mappi !== void 0 ? _savedQuery$ecs_mappi : {}
      });
      if (!(0, _lodash.isEmpty)(savedQuery.ecs_mapping)) {
        setAdvancedContentState('open');
      }
    } else {
      resetField('savedQueryId');
    }
  }, [resetField]);
  const handleToggle = (0, _react.useCallback)(isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setAdvancedContentState(newState);
  }, []);
  const ecsFieldProps = (0, _react.useMemo)(() => ({
    isDisabled: !permissions.writeLiveQueries
  }), [permissions.writeLiveQueries]);
  const isAdvancedToggleHidden = (0, _react.useMemo)(() => !(permissions.writeLiveQueries || permissions.runSavedQueries && permissions.readSavedQueries), [permissions.readSavedQueries, permissions.runSavedQueries, permissions.writeLiveQueries]);
  const isSavedQueryDisabled = (0, _react.useMemo)(() => !permissions.runSavedQueries || !permissions.readSavedQueries, [permissions.readSavedQueries, permissions.runSavedQueries]);
  const commands = (0, _react.useMemo)(() => handleSubmitForm ? [{
    name: 'submitOnCmdEnter',
    exec: handleSubmitForm
  }] : [], [handleSubmitForm]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isSavedQueryDisabled && /*#__PURE__*/_react.default.createElement(_saved_queries_dropdown.SavedQueriesDropdown, {
    disabled: isSavedQueryDisabled,
    onChange: handleSavedQueryChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !!(error !== null && error !== void 0 && error.message),
    error: error === null || error === void 0 ? void 0 : error.message,
    fullWidth: true,
    isDisabled: !permissions.writeLiveQueries || disabled
  }, !permissions.writeLiveQueries || disabled ? /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, {
    language: "sql",
    fontSize: "m",
    paddingSize: "m",
    transparentBackground: !value.length
  }, value) : /*#__PURE__*/_react.default.createElement(_editor.OsqueryEditor, {
    defaultValue: value,
    onChange: onChange,
    commands: commands
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !isAdvancedToggleHidden && /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: "advanced",
    forceState: advancedContentState,
    onToggle: handleToggle,
    buttonContent: "Advanced",
    "data-test-subj": "advanced-accordion-content"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_lazy_ecs_mapping_editor_field.ECSMappingEditorField, {
    euiFieldProps: ecsFieldProps
  })));
};
const LiveQueryQueryField = /*#__PURE__*/_react.default.memo(LiveQueryQueryFieldComponent);

// eslint-disable-next-line import/no-default-export
exports.default = exports.LiveQueryQueryField = LiveQueryQueryField;