"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _public = require("@kbn/kibana-react-plugin/public");
var _monaco = require("@kbn/monaco");
var _osquery_highlight_rules = require("./osquery_highlight_rules");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const editorOptions = {
  theme: 'osquery',
  automaticLayout: true
};
const MIN_HEIGHT = 100;
const OsqueryEditorComponent = ({
  defaultValue,
  onChange,
  commands
}) => {
  const [editorValue, setEditorValue] = (0, _react.useState)(defaultValue !== null && defaultValue !== void 0 ? defaultValue : '');
  const [height, setHeight] = (0, _react.useState)(MIN_HEIGHT);
  (0, _useDebounce.default)(() => {
    onChange(editorValue);
  }, 500, [editorValue]);
  (0, _react.useEffect)(() => setEditorValue(defaultValue), [defaultValue]);
  (0, _react.useEffect)(() => {
    const disposable = (0, _osquery_highlight_rules.initializeOsqueryEditor)();
    return () => {
      disposable === null || disposable === void 0 ? void 0 : disposable.dispose();
    };
  }, []);
  const editorDidMount = (0, _react.useCallback)(editor => {
    const minHeight = 100;
    const maxHeight = 1000;
    commands === null || commands === void 0 ? void 0 : commands.map(command => {
      if (command.name === 'submitOnCmdEnter') {
        // on CMD/CTRL + Enter submit the query
        // eslint-disable-next-line no-bitwise
        editor.addCommand(_monaco.monaco.KeyMod.CtrlCmd | _monaco.monaco.KeyCode.Enter, command.exec);
      }
    });
    const updateHeight = () => {
      const contentHeight = Math.min(maxHeight, Math.max(minHeight, editor.getContentHeight()));
      setHeight(contentHeight);
    };
    editor.onDidContentSizeChange(updateHeight);
  }, [commands]);
  return /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    languageId: 'sql',
    value: editorValue,
    onChange: setEditorValue,
    options: editorOptions,
    height: height + 'px',
    width: "100%",
    editorDidMount: editorDidMount
  });
};
const OsqueryEditor = /*#__PURE__*/_react.default.memo(OsqueryEditorComponent);
exports.OsqueryEditor = OsqueryEditor;