"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewResultsInDiscoverAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _kibana = require("../common/lib/kibana");
var _use_logs_data_view = require("../common/hooks/use_logs_data_view");
var _pack_queries_status_table = require("../live_queries/form/pack_queries_status_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewResultsInDiscoverActionComponent = ({
  actionId,
  buttonType,
  endDate,
  startDate
}) => {
  const {
    discover,
    application
  } = (0, _kibana.useKibana)().services;
  const locator = discover === null || discover === void 0 ? void 0 : discover.locator;
  const discoverPermissions = application.capabilities.discover;
  const {
    data: logsDataView
  } = (0, _use_logs_data_view.useLogsDataView)({
    skip: !actionId,
    checkOnly: true
  });
  const [discoverUrl, setDiscoverUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const getDiscoverUrl = async () => {
      if (!locator || !logsDataView) return;
      const newUrl = await locator.getUrl({
        indexPatternId: logsDataView.id,
        filters: [{
          meta: {
            index: logsDataView.id,
            alias: null,
            negate: false,
            disabled: false,
            type: 'phrase',
            key: 'action_id',
            params: {
              query: actionId
            }
          },
          query: {
            match_phrase: {
              action_id: actionId
            }
          },
          $state: {
            store: _esQuery.FilterStateStore.APP_STATE
          }
        }],
        refreshInterval: {
          pause: true,
          value: 0
        },
        timeRange: startDate && endDate ? {
          to: endDate,
          from: startDate,
          mode: 'absolute'
        } : {
          to: 'now',
          from: 'now-1d',
          mode: 'relative'
        }
      });
      setDiscoverUrl(newUrl);
    };
    getDiscoverUrl();
  }, [actionId, endDate, startDate, locator, logsDataView]);
  if (!discoverPermissions.show) {
    return null;
  }
  if (buttonType === _pack_queries_status_table.ViewResultsActionButtonType.button) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconType: "discoverApp",
      href: discoverUrl,
      target: "_blank"
    }, VIEW_IN_DISCOVER);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_IN_DISCOVER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "discoverApp",
    "aria-label": VIEW_IN_DISCOVER,
    href: discoverUrl,
    target: "_blank",
    isDisabled: !actionId || !discoverUrl.length
  }));
};
const VIEW_IN_DISCOVER = _i18n.i18n.translate('xpack.osquery.pack.queriesTable.viewDiscoverResultsActionAriaLabel', {
  defaultMessage: 'View in Discover'
});
const ViewResultsInDiscoverAction = /*#__PURE__*/_react.default.memo(ViewResultsInDiscoverActionComponent);
exports.ViewResultsInDiscoverAction = ViewResultsInDiscoverAction;