"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentPolicyAgentIds = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _use_error_toast = require("../common/hooks/use_error_toast");
var _kibana = require("../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentPolicyAgentIds = ({
  agentPolicyId,
  silent,
  skip
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['agentPolicyAgentIds', agentPolicyId], () => {
    const kuery = `${_common.AGENTS_PREFIX}.policy_id:${agentPolicyId}`;
    return http.get(`/internal/osquery/fleet_wrapper/agents`, {
      query: {
        kuery,
        perPage: 10000
      }
    });
  }, {
    select: data => (0, _lodash.map)(data === null || data === void 0 ? void 0 : data.agents, 'id') || [],
    enabled: !skip || !agentPolicyId,
    onSuccess: () => setErrorToast(),
    onError: error => !silent && setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.agents.fetchError', {
        defaultMessage: 'Error while fetching agents'
      })
    }),
    refetchOnReconnect: false,
    refetchOnWindowFocus: false
  });
};
exports.useAgentPolicyAgentIds = useAgentPolicyAgentIds;