"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetSLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GetSLO {
  constructor(repository, summaryClient) {
    this.repository = repository;
    this.summaryClient = summaryClient;
  }
  async execute(sloId) {
    const slo = await this.repository.findById(sloId);
    const summaryBySlo = await this.summaryClient.fetchSummary([slo]);
    const sloWithSummary = mergeSloWithSummary(slo, summaryBySlo);
    return _sloSchema.getSLOResponseSchema.encode(sloWithSummary);
  }
}
exports.GetSLO = GetSLO;
function mergeSloWithSummary(slo, summaryBySlo) {
  return {
    ...slo,
    summary: summaryBySlo[slo.id]
  };
}