"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenAIClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _openai = require("openai");
var _pipe_streaming_response = require("./pipe_streaming_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class OpenAIClient {
  constructor(config) {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "chatCompletion", {
      create: async messages => {
        const response = await this.client.createChatCompletion({
          messages,
          model: this.config.model,
          stream: true
        }, {
          responseType: 'stream'
        });
        return (0, _pipe_streaming_response.pipeStreamingResponse)(response);
      }
    });
    this.config = config;
    const clientConfig = new _openai.Configuration({
      apiKey: config.apiKey
    });
    this.client = new _openai.OpenAIApi(clientConfig);
  }
}
exports.OpenAIClient = OpenAIClient;