"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenAIService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _azure_openai_client = require("./azure_openai_client");
var _openai_client = require("./openai_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class OpenAIService {
  constructor(config) {
    (0, _defineProperty2.default)(this, "client", void 0);
    if ('openAI' in config.provider) {
      this.client = new _openai_client.OpenAIClient(config.provider.openAI);
    } else {
      this.client = new _azure_openai_client.AzureOpenAIClient(config.provider.azureOpenAI);
    }
  }
}
exports.OpenAIService = OpenAIService;