"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureOpenAIClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _axios = _interopRequireDefault(require("axios"));
var _url = require("url");
var _pipe_streaming_response = require("./pipe_streaming_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AzureOpenAIClient {
  constructor(config) {
    (0, _defineProperty2.default)(this, "chatCompletion", {
      create: async messages => {
        const response = await _axios.default.post((0, _url.format)({
          host: `${this.config.resourceName}.openai.azure.com`,
          pathname: `/openai/deployments/${this.config.deploymentId}/chat/completions`,
          protocol: 'https',
          query: {
            'api-version': '2023-05-15'
          }
        }), {
          messages,
          stream: true
        }, {
          headers: {
            'api-key': this.config.apiKey
          },
          responseType: 'stream'
        });
        return (0, _pipe_streaming_response.pipeStreamingResponse)(response);
      }
    });
    this.config = config;
  }
}
exports.AzureOpenAIClient = AzureOpenAIClient;