"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateCompositeSLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _composite_slo = require("../../domain/services/composite_slo");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UpdateCompositeSLO {
  constructor(compositeSloRepository, sloRepository) {
    this.compositeSloRepository = compositeSloRepository;
    this.sloRepository = sloRepository;
  }
  async execute(compositeSloId, params) {
    const originalCompositeSlo = await this.compositeSloRepository.findById(compositeSloId);
    const updatedCompositeSlo = Object.assign({}, originalCompositeSlo, params, {
      updatedAt: new Date()
    });
    const sloList = await this.sloRepository.findAllByIds(updatedCompositeSlo.sources.map(slo => slo.id));
    (0, _composite_slo.validateCompositeSLO)(updatedCompositeSlo, sloList);
    await this.compositeSloRepository.save(updatedCompositeSlo);
    return toResponse(updatedCompositeSlo);
  }
}
exports.UpdateCompositeSLO = UpdateCompositeSLO;
function toResponse(compositeSlo) {
  return _sloSchema.updateCompositeSLOResponseSchema.encode(compositeSlo);
}