"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.slo = exports.SO_SLO_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateSlo890 = doc => {
  const {
    timeWindow,
    ...other
  } = doc.attributes;
  return {
    ...doc,
    attributes: {
      ...other,
      timeWindow: {
        duration: timeWindow.duration,
        type: timeWindow.isCalendar ? 'calendarAligned' : 'rolling'
      }
    }
  };
};
const SO_SLO_TYPE = 'slo';
exports.SO_SLO_TYPE = SO_SLO_TYPE;
const slo = {
  name: SO_SLO_TYPE,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {
      id: {
        type: 'keyword'
      },
      name: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      indicator: {
        properties: {
          type: {
            type: 'keyword'
          },
          params: {
            type: 'flattened'
          }
        }
      },
      budgetingMethod: {
        type: 'keyword'
      },
      enabled: {
        type: 'boolean'
      },
      tags: {
        type: 'keyword'
      }
    }
  },
  management: {
    displayName: 'SLO',
    importableAndExportable: true,
    getTitle(sloSavedObject) {
      return `SLO: [${sloSavedObject.attributes.name}]`;
    }
  },
  migrations: {
    '8.9.0': migrateSlo890
  }
};
exports.slo = slo;