"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getObservabilityServerRouteRepository = getObservabilityServerRouteRepository;
var _route = require("./composite_slo/route");
var _route2 = require("./copilot/route");
var _route3 = require("./rules/route");
var _route4 = require("./slo/route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getObservabilityServerRouteRepository(config) {
  const isCompositeSloFeatureEnabled = config.compositeSlo.enabled;
  const repository = {
    ..._route3.rulesRouteRepository,
    ..._route4.sloRouteRepository,
    ...(isCompositeSloFeatureEnabled ? _route.compositeSloRouteRepository : {}),
    ..._route2.observabilityCoPilotRouteRepository
  };
  return repository;
}