"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compositeSloRouteRepository = void 0;
var _boom = require("@hapi/boom");
var _sloSchema = require("@kbn/slo-schema");
var _composite_slo = require("../../services/composite_slo");
var _get_composite_slo = require("../../services/composite_slo/get_composite_slo");
var _slo = require("../../services/slo");
var _create_observability_server_route = require("../create_observability_server_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assertLicenseAtLeastPlatinum = async context => {
  const {
    license
  } = await context.licensing;
  if (!license.hasAtLeast('platinum')) {
    throw (0, _boom.badRequest)('Platinum license or higher is needed to make use of this feature.');
  }
};
const createCompositeSLORoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'POST /api/observability/composite_slos 2023-05-24',
  options: {
    tags: ['access:slo_write']
  },
  params: _sloSchema.createCompositeSLOParamsSchema,
  handler: async ({
    context,
    params
  }) => {
    await assertLicenseAtLeastPlatinum(context);
    const soClient = (await context.core).savedObjects.client;
    const compositeSloRepository = new _composite_slo.KibanaSavedObjectsCompositeSLORepository(soClient);
    const sloRepository = new _slo.KibanaSavedObjectsSLORepository(soClient);
    const createCompositeSLO = new _composite_slo.CreateCompositeSLO(compositeSloRepository, sloRepository);
    const response = await createCompositeSLO.execute(params.body);
    return response;
  }
});
const updateCompositeSLORoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'PUT /api/observability/composite_slos/{id} 2023-05-24',
  options: {
    tags: ['access:slo_write']
  },
  params: _sloSchema.updateCompositeSLOParamsSchema,
  handler: async ({
    context,
    params
  }) => {
    await assertLicenseAtLeastPlatinum(context);
    const soClient = (await context.core).savedObjects.client;
    const compositeSloRepository = new _composite_slo.KibanaSavedObjectsCompositeSLORepository(soClient);
    const sloRepository = new _slo.KibanaSavedObjectsSLORepository(soClient);
    const updateCompositeSLO = new _composite_slo.UpdateCompositeSLO(compositeSloRepository, sloRepository);
    const response = await updateCompositeSLO.execute(params.path.id, params.body);
    return response;
  }
});
const deleteCompositeSLORoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'DELETE /api/observability/composite_slos/{id} 2023-05-24',
  options: {
    tags: ['access:slo_write']
  },
  params: _sloSchema.deleteCompositeSLOParamsSchema,
  handler: async ({
    context,
    params
  }) => {
    await assertLicenseAtLeastPlatinum(context);
    const soClient = (await context.core).savedObjects.client;
    const compositeSloRepository = new _composite_slo.KibanaSavedObjectsCompositeSLORepository(soClient);
    const deleteCompositeSLO = new _composite_slo.DeleteCompositeSLO(compositeSloRepository);
    await deleteCompositeSLO.execute(params.path.id);
  }
});
const getCompositeSLORoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'GET /api/observability/composite_slos/{id} 2023-05-24',
  options: {
    tags: ['access:slo_read']
  },
  params: _sloSchema.getCompositeSLOParamsSchema,
  handler: async ({
    context,
    params
  }) => {
    await assertLicenseAtLeastPlatinum(context);
    const soClient = (await context.core).savedObjects.client;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const compositeSloRepository = new _composite_slo.KibanaSavedObjectsCompositeSLORepository(soClient);
    const summaryClient = new _composite_slo.DefaultSummaryClient(esClient);
    const getCompositeSlo = new _get_composite_slo.GetCompositeSLO(compositeSloRepository, summaryClient);
    const response = await getCompositeSlo.execute(params.path.id);
    return response;
  }
});
const findCompositeSLORoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'GET /api/observability/composite_slos 2023-05-24',
  options: {
    tags: ['access:slo_read']
  },
  params: _sloSchema.findCompositeSLOParamsSchema,
  handler: async ({
    context,
    params
  }) => {
    var _params$query;
    await assertLicenseAtLeastPlatinum(context);
    const soClient = (await context.core).savedObjects.client;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const repository = new _composite_slo.KibanaSavedObjectsCompositeSLORepository(soClient);
    const summaryClient = new _composite_slo.DefaultSummaryClient(esClient);
    const findCompositeSlo = new _composite_slo.FindCompositeSLO(repository, summaryClient);
    const response = await findCompositeSlo.execute((_params$query = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query !== void 0 ? _params$query : {});
    return response;
  }
});
const compositeSloRouteRepository = {
  ...createCompositeSLORoute,
  ...updateCompositeSLORoute,
  ...deleteCompositeSLORoute,
  ...getCompositeSLORoute,
  ...findCompositeSLORoute
};
exports.compositeSloRouteRepository = compositeSloRouteRepository;