"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraRuleType = exports.AlertStates = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let InfraRuleType;
exports.InfraRuleType = InfraRuleType;
(function (InfraRuleType) {
  InfraRuleType["MetricThreshold"] = "metrics.alert.threshold";
  InfraRuleType["InventoryThreshold"] = "metrics.alert.inventory.threshold";
  InfraRuleType["Anomaly"] = "metrics.alert.anomaly";
})(InfraRuleType || (exports.InfraRuleType = InfraRuleType = {}));
let AlertStates;
exports.AlertStates = AlertStates;
(function (AlertStates) {
  AlertStates[AlertStates["OK"] = 0] = "OK";
  AlertStates[AlertStates["ALERT"] = 1] = "ALERT";
  AlertStates[AlertStates["NO_DATA"] = 2] = "NO_DATA";
  AlertStates[AlertStates["ERROR"] = 3] = "ERROR";
})(AlertStates || (exports.AlertStates = AlertStates = {}));
const metricAnomalyNodeTypeRT = rt.union([rt.literal('hosts'), rt.literal('k8s')]);
const metricAnomalyMetricRT = rt.union([rt.literal('memory_usage'), rt.literal('network_in'), rt.literal('network_out')]);
const metricAnomalyInfluencerFilterRT = rt.type({
  fieldName: rt.string,
  fieldValue: rt.string
});