"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timestamps = exports.timeRange = exports.source = exports.resp = exports.options = exports.derivedIndexPattern = exports.createSeries = exports.chartOptions = void 0;
var _use_metrics_explorer_options = require("../components/threshold/hooks/use_metrics_explorer_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = {
  limit: 3,
  groupBy: 'host.name',
  aggregation: 'avg',
  metrics: [{
    aggregation: 'avg',
    field: 'system.cpu.user.pct'
  }]
};
exports.options = options;
const source = {
  name: 'default',
  description: '',
  metricAlias: 'metricbeat-*',
  inventoryDefaultView: 'host',
  metricsExplorerDefaultView: 'host',
  fields: {
    host: 'host.name',
    container: 'container.id',
    pod: 'kubernetes.pod.uid',
    timestamp: '@timestamp',
    message: ['message'],
    tiebreaker: '@timestamp'
  },
  anomalyThreshold: 20
};
exports.source = source;
const chartOptions = {
  type: _use_metrics_explorer_options.MetricsExplorerChartType.line,
  yAxisMode: _use_metrics_explorer_options.MetricsExplorerYAxisMode.fromZero,
  stack: false
};
exports.chartOptions = chartOptions;
const derivedIndexPattern = {
  title: 'metricbeat-*',
  fields: []
};
exports.derivedIndexPattern = derivedIndexPattern;
const timeRange = {
  from: 'now-1h',
  to: 'now',
  interval: '>=10s'
};
exports.timeRange = timeRange;
const timestamps = {
  fromTimestamp: 1678376367166,
  toTimestamp: 1678379973620,
  interval: '>=10s'
};
exports.timestamps = timestamps;
const createSeries = id => ({
  id,
  columns: [{
    name: 'timestamp',
    type: 'date'
  }, {
    name: 'metric_0',
    type: 'number'
  }, {
    name: 'groupBy',
    type: 'string'
  }],
  rows: [{
    timestamp: 1,
    metric_0: 0.5,
    groupBy: id
  }, {
    timestamp: 2,
    metric_0: 0.5,
    groupBy: id
  }, {
    timestamp: 3,
    metric_0: 0.5,
    groupBy: id
  }]
});
exports.createSeries = createSeries;
const resp = {
  pageInfo: {
    total: 10,
    afterKey: 'host-04'
  },
  series: [createSeries('host-01'), createSeries('host-02'), createSeries('host-03')]
};
exports.resp = resp;