"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListItem = SloListItem;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _query_key_factory = require("../../../hooks/slo/query_key_factory");
var _use_capabilities = require("../../../hooks/slo/use_capabilities");
var _kibana_react = require("../../../utils/kibana_react");
var _use_clone_slo = require("../../../hooks/slo/use_clone_slo");
var _use_get_filtered_rule_types = require("../../../hooks/use_get_filtered_rule_types");
var _slo_summary = require("./slo_summary");
var _slo_delete_confirmation_modal = require("./slo_delete_confirmation_modal");
var _slo_badges = require("./badges/slo_badges");
var _process_slo_form_values = require("../../slo_edit/helpers/process_slo_form_values");
var _constants = require("../../../../common/constants");
var _common = require("../../../../common");
var _paths = require("../../../config/paths");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloListItem({
  slo,
  rules,
  historicalSummary = [],
  historicalSummaryLoading,
  activeAlerts,
  onConfirmDelete
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    share: {
      url: {
        locators
      }
    },
    triggersActionsUi: {
      getAddRuleFlyout: AddRuleFlyout
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    mutate: cloneSlo
  } = (0, _use_clone_slo.useCloneSlo)();
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const [isAddRuleFlyoutOpen, setIsAddRuleFlyoutOpen] = (0, _react.useState)(false);
  const [isDeleteConfirmationModalOpen, setDeleteConfirmationModalOpen] = (0, _react.useState)(false);
  const handleClickActions = () => {
    setIsActionsPopoverOpen(!isActionsPopoverOpen);
  };
  const handleViewDetails = () => {
    navigateToUrl(basePath.prepend(_paths.paths.observability.sloDetails(slo.id)));
  };
  const handleEdit = () => {
    navigateToUrl(basePath.prepend(_paths.paths.observability.sloEdit(slo.id)));
  };
  const handleCreateRule = () => {
    setIsActionsPopoverOpen(false);
    setIsAddRuleFlyoutOpen(true);
  };
  const handleSavedRule = async () => {
    queryClient.invalidateQueries({
      queryKey: _query_key_factory.sloKeys.rules(),
      exact: false
    });
  };
  const handleNavigateToRules = async () => {
    const locator = locators.get(_common.rulesLocatorID);
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      params: {
        sloId: slo.id
      }
    }, {
      replace: true
    });
  };
  const handleClone = () => {
    const newSlo = (0, _process_slo_form_values.transformCreateSLOFormToCreateSLOInput)((0, _process_slo_form_values.transformSloResponseToCreateSloForm)({
      ...slo,
      name: `[Copy] ${slo.name}`
    }));
    cloneSlo({
      slo: newSlo,
      originalSloId: slo.id
    });
    setIsActionsPopoverOpen(false);
  };
  const handleDelete = () => {
    setDeleteConfirmationModalOpen(true);
    setIsActionsPopoverOpen(false);
  };
  const handleDeleteConfirm = () => {
    setDeleteConfirmationModalOpen(false);
    onConfirmDelete(slo);
  };
  const handleDeleteCancel = () => {
    setDeleteConfirmationModalOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "sloItem",
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, slo.summary ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11ySloListItemLink",
    onClick: handleViewDetails
  }, slo.name) : /*#__PURE__*/_react.default.createElement("span", null, slo.name))), /*#__PURE__*/_react.default.createElement(_slo_badges.SloBadges, {
    activeAlerts: activeAlerts,
    isLoading: !slo.summary,
    rules: rules,
    slo: slo,
    onClickRuleBadge: handleCreateRule
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, slo.summary ? /*#__PURE__*/_react.default.createElement(_slo_summary.SloSummary, {
    slo: slo,
    historicalSummary: historicalSummary,
    historicalSummaryLoading: historicalSummaryLoading
  }) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": "Actions",
      color: "text",
      disabled: !slo.summary,
      display: "empty",
      iconType: "boxesVertical",
      size: "s",
      onClick: handleClickActions
    }),
    panelPaddingSize: "m",
    closePopover: handleClickActions,
    isOpen: isActionsPopoverOpen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "m",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "view",
      icon: "inspect",
      onClick: handleViewDetails,
      "data-test-subj": "sloActionsView"
    }, _i18n.i18n.translate('xpack.observability.slo.slo.item.actions.details', {
      defaultMessage: 'Details'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "edit",
      icon: "pencil",
      disabled: !hasWriteCapabilities,
      onClick: handleEdit,
      "data-test-subj": "sloActionsEdit"
    }, _i18n.i18n.translate('xpack.observability.slo.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createRule",
      icon: "bell",
      disabled: !hasWriteCapabilities,
      onClick: handleCreateRule,
      "data-test-subj": "sloActionsCreateRule"
    }, _i18n.i18n.translate('xpack.observability.slo.slo.item.actions.createRule', {
      defaultMessage: 'Create new alert rule'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "manageRules",
      icon: "gear",
      disabled: !hasWriteCapabilities,
      onClick: handleNavigateToRules,
      "data-test-subj": "sloActionsManageRules"
    }, _i18n.i18n.translate('xpack.observability.slo.slo.item.actions.manageRules', {
      defaultMessage: 'Manage rules'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "clone",
      disabled: !hasWriteCapabilities,
      icon: "copy",
      onClick: handleClone,
      "data-test-subj": "sloActionsClone"
    }, _i18n.i18n.translate('xpack.observability.slo.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "delete",
      icon: "trash",
      disabled: !hasWriteCapabilities,
      onClick: handleDelete,
      "data-test-subj": "sloActionsDelete"
    }, _i18n.i18n.translate('xpack.observability.slo.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }))]
  })))), isAddRuleFlyoutOpen ? /*#__PURE__*/_react.default.createElement(AddRuleFlyout, {
    consumer: _common.sloFeatureId,
    filteredRuleTypes: filteredRuleTypes,
    ruleTypeId: _constants.SLO_BURN_RATE_RULE_TYPE_ID,
    initialValues: {
      name: `${slo.name} Burn Rate rule`,
      params: {
        sloId: slo.id
      }
    },
    onSave: handleSavedRule,
    onClose: () => {
      setIsAddRuleFlyoutOpen(false);
    }
  }) : null, isDeleteConfirmationModalOpen ? /*#__PURE__*/_react.default.createElement(_slo_delete_confirmation_modal.SloDeleteConfirmationModal, {
    slo: slo,
    onCancel: handleDeleteCancel,
    onConfirm: handleDeleteConfirm
  }) : null);
}