"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformCreateSLOFormToCreateSLOInput = transformCreateSLOFormToCreateSLOInput;
exports.transformPartialCreateSLOInputToPartialCreateSLOForm = transformPartialCreateSLOInputToPartialCreateSLOForm;
exports.transformSloResponseToCreateSloForm = transformSloResponseToCreateSloForm;
exports.transformValuesToUpdateSLOInput = transformValuesToUpdateSLOInput;
var _duration = require("../../../utils/slo/duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformSloResponseToCreateSloForm(values) {
  if (!values) return undefined;
  return {
    name: values.name,
    description: values.description,
    indicator: values.indicator,
    budgetingMethod: values.budgetingMethod,
    timeWindow: {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    },
    objective: {
      target: values.objective.target * 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget * 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: String((0, _duration.toDuration)(values.objective.timesliceWindow).value)
      })
    },
    tags: values.tags
  };
}
function transformCreateSLOFormToCreateSLOInput(values) {
  return {
    name: values.name,
    description: values.description,
    indicator: values.indicator,
    budgetingMethod: values.budgetingMethod,
    timeWindow: {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    },
    objective: {
      target: values.objective.target / 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget / 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: `${values.objective.timesliceWindow}m`
      })
    },
    tags: values.tags
  };
}
function transformValuesToUpdateSLOInput(values) {
  return {
    name: values.name,
    description: values.description,
    indicator: values.indicator,
    budgetingMethod: values.budgetingMethod,
    timeWindow: {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    },
    objective: {
      target: values.objective.target / 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget / 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: `${values.objective.timesliceWindow}m`
      })
    },
    tags: values.tags
  };
}
function transformPartialCreateSLOInputToPartialCreateSLOForm(values) {
  return {
    ...values,
    ...(values.objective && {
      objective: {
        target: values.objective.target * 100,
        ...(values.objective.timesliceTarget && {
          timesliceTarget: values.objective.timesliceTarget * 100
        }),
        ...(values.objective.timesliceWindow && {
          timesliceWindow: String((0, _duration.toDuration)(values.objective.timesliceWindow).value)
        })
      }
    })
  };
}