"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMEWINDOW_TYPE_OPTIONS = exports.SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC = exports.SLO_EDIT_FORM_DEFAULT_VALUES = exports.SLI_OPTIONS = exports.ROLLING_TIMEWINDOW_OPTIONS = exports.CUSTOM_METRIC_DEFAULT_VALUES = exports.CUSTOM_KQL_DEFAULT_VALUES = exports.CALENDARALIGNED_TIMEWINDOW_OPTIONS = exports.BUDGETING_METHOD_OPTIONS = exports.APM_LATENCY_DEFAULT_VALUES = exports.APM_AVAILABILITY_DEFAULT_VALUES = void 0;
var _i18n = require("@kbn/i18n");
var _labels = require("../../utils/slo/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLI_OPTIONS = [{
  value: 'sli.kql.custom',
  text: _labels.INDICATOR_CUSTOM_KQL
}, {
  value: 'sli.metric.custom',
  text: _labels.INDICATOR_CUSTOM_METRIC
}, {
  value: 'sli.apm.transactionDuration',
  text: _labels.INDICATOR_APM_LATENCY
}, {
  value: 'sli.apm.transactionErrorRate',
  text: _labels.INDICATOR_APM_AVAILABILITY
}];
exports.SLI_OPTIONS = SLI_OPTIONS;
const BUDGETING_METHOD_OPTIONS = [{
  value: 'occurrences',
  text: _labels.BUDGETING_METHOD_OCCURRENCES
}, {
  value: 'timeslices',
  text: _labels.BUDGETING_METHOD_TIMESLICES
}];
exports.BUDGETING_METHOD_OPTIONS = BUDGETING_METHOD_OPTIONS;
const TIMEWINDOW_TYPE_OPTIONS = [{
  value: 'rolling',
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timeWindow.rolling', {
    defaultMessage: 'Rolling'
  })
}, {
  value: 'calendarAligned',
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timeWindow.calendarAligned', {
    defaultMessage: 'Calendar aligned'
  })
}];
exports.TIMEWINDOW_TYPE_OPTIONS = TIMEWINDOW_TYPE_OPTIONS;
const CALENDARALIGNED_TIMEWINDOW_OPTIONS = [{
  value: '1w',
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.calendarTimeWindow.weekly', {
    defaultMessage: 'Weekly'
  })
}, {
  value: '1M',
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.calendarTimeWindow.monthly', {
    defaultMessage: 'Monthly'
  })
}];
exports.CALENDARALIGNED_TIMEWINDOW_OPTIONS = CALENDARALIGNED_TIMEWINDOW_OPTIONS;
const ROLLING_TIMEWINDOW_OPTIONS = [90, 30, 7].map(number => ({
  value: `${number}d`,
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.rollingTimeWindow.days', {
    defaultMessage: '{number} days',
    values: {
      number
    }
  })
}));
exports.ROLLING_TIMEWINDOW_OPTIONS = ROLLING_TIMEWINDOW_OPTIONS;
const CUSTOM_KQL_DEFAULT_VALUES = {
  type: 'sli.kql.custom',
  params: {
    index: '',
    filter: '',
    good: '',
    total: '',
    timestampField: ''
  }
};
exports.CUSTOM_KQL_DEFAULT_VALUES = CUSTOM_KQL_DEFAULT_VALUES;
const CUSTOM_METRIC_DEFAULT_VALUES = {
  type: 'sli.metric.custom',
  params: {
    index: '',
    filter: '',
    good: {
      metrics: [{
        name: 'A',
        aggregation: 'sum',
        field: ''
      }],
      equation: 'A'
    },
    total: {
      metrics: [{
        name: 'A',
        aggregation: 'sum',
        field: ''
      }],
      equation: 'A'
    },
    timestampField: ''
  }
};
exports.CUSTOM_METRIC_DEFAULT_VALUES = CUSTOM_METRIC_DEFAULT_VALUES;
const APM_LATENCY_DEFAULT_VALUES = {
  type: 'sli.apm.transactionDuration',
  params: {
    service: '',
    environment: '',
    transactionType: '',
    transactionName: '',
    threshold: 250,
    filter: '',
    index: ''
  }
};
exports.APM_LATENCY_DEFAULT_VALUES = APM_LATENCY_DEFAULT_VALUES;
const APM_AVAILABILITY_DEFAULT_VALUES = {
  type: 'sli.apm.transactionErrorRate',
  params: {
    service: '',
    environment: '',
    transactionType: '',
    transactionName: '',
    filter: '',
    index: ''
  }
};
exports.APM_AVAILABILITY_DEFAULT_VALUES = APM_AVAILABILITY_DEFAULT_VALUES;
const SLO_EDIT_FORM_DEFAULT_VALUES = {
  name: '',
  description: '',
  indicator: CUSTOM_KQL_DEFAULT_VALUES,
  timeWindow: {
    duration: ROLLING_TIMEWINDOW_OPTIONS[1].value,
    type: 'rolling'
  },
  tags: [],
  budgetingMethod: BUDGETING_METHOD_OPTIONS[0].value,
  objective: {
    target: 99
  }
};
exports.SLO_EDIT_FORM_DEFAULT_VALUES = SLO_EDIT_FORM_DEFAULT_VALUES;
const SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC = {
  name: '',
  description: '',
  indicator: CUSTOM_METRIC_DEFAULT_VALUES,
  timeWindow: {
    duration: ROLLING_TIMEWINDOW_OPTIONS[1].value,
    type: 'rolling'
  },
  tags: [],
  budgetingMethod: BUDGETING_METHOD_OPTIONS[0].value,
  objective: {
    target: 99
  }
};
exports.SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC = SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC;