"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataPreviewChart = DataPreviewChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _kibana_react = require("../../../../utils/kibana_react");
var _use_preview = require("../../hooks/use_preview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataPreviewChart() {
  const {
    watch,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const {
    charts,
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const {
    data: previewData,
    isLoading: isPreviewLoading
  } = (0, _use_preview.useDebouncedGetPreviewData)(watch('indicator'));
  const theme = charts.theme.useChartsTheme();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const dateFormat = uiSettings.get('dateFormat');
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  if (getFieldState('indicator').invalid) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isPreviewLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m",
    mono: true
  }), !isPreviewLoading && !!previewData && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 160,
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: "vertical"
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: false,
    theme: [{
      ...theme,
      lineSeriesStyle: {
        point: {
          visible: false
        }
      }
    }],
    noResults: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "l",
      color: "subdued",
      title: "no results"
    })
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.dataPreviewChart.yTitle', {
      defaultMessage: 'SLI'
    }),
    ticks: 5,
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format(percentFormat)
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "time",
    title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.dataPreviewChart.xTitle', {
      defaultMessage: 'Last hour'
    }),
    tickFormat: d => (0, _moment.default)(d).format(dateFormat),
    position: _charts.Position.Bottom,
    timeAxisLayerCount: 2,
    gridLine: {
      visible: true
    },
    style: {
      tickLine: {
        size: 0.0001,
        padding: 4,
        visible: true
      },
      tickLabel: {
        alignment: {
          horizontal: _charts.Position.Left,
          vertical: _charts.Position.Bottom
        },
        padding: 0,
        offset: {
          x: 0,
          y: 0
        }
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "SLI",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "date",
    yAccessors: ['value'],
    data: previewData.map(datum => ({
      date: new Date(datum.date).getTime(),
      value: datum.sliValue >= 0 ? datum.sliValue : null
    }))
  }))));
}