"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderTitle = HeaderTitle;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _slo_status_badge = require("../../../components/slo/slo_status_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderTitle(props) {
  const {
    isLoading,
    slo
  } = props;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": "loadingTitle"
    });
  }
  if (!slo) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, slo.name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_slo_status_badge.SloStatusBadge, {
    slo: slo
  })));
}