"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderControl = HeaderControl;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_capabilities = require("../../../hooks/slo/use_capabilities");
var _kibana_react = require("../../../utils/kibana_react");
var _use_clone_slo = require("../../../hooks/slo/use_clone_slo");
var _use_delete_slo = require("../../../hooks/slo/use_delete_slo");
var _indicator = require("../../../utils/slo/indicator");
var _convert_sli_apm_params_to_apm_app_deeplink_url = require("../../../utils/slo/convert_sli_apm_params_to_apm_app_deeplink_url");
var _constants = require("../../../../common/constants");
var _common = require("../../../../common");
var _paths = require("../../../config/paths");
var _process_slo_form_values = require("../../slo_edit/helpers/process_slo_form_values");
var _slo_delete_confirmation_modal = require("../../slos/components/slo_delete_confirmation_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderControl({
  isLoading,
  slo
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    share: {
      url: {
        locators
      }
    },
    triggersActionsUi: {
      getAddRuleFlyout: AddRuleFlyout
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isRuleFlyoutVisible, setRuleFlyoutVisibility] = (0, _react.useState)(false);
  const [isDeleteConfirmationModalOpen, setDeleteConfirmationModalOpen] = (0, _react.useState)(false);
  const {
    mutate: cloneSlo
  } = (0, _use_clone_slo.useCloneSlo)();
  const {
    mutate: deleteSlo
  } = (0, _use_delete_slo.useDeleteSlo)();
  const handleActionsClick = () => setIsPopoverOpen(value => !value);
  const closePopover = () => setIsPopoverOpen(false);
  const handleEdit = () => {
    if (slo) {
      navigate(basePath.prepend(_paths.paths.observability.sloEdit(slo.id)));
    }
  };
  const onCloseRuleFlyout = () => {
    setRuleFlyoutVisibility(false);
  };
  const handleOpenRuleFlyout = () => {
    closePopover();
    setRuleFlyoutVisibility(true);
  };
  const handleNavigateToRules = async () => {
    const locator = locators.get(_common.rulesLocatorID);
    if (slo !== null && slo !== void 0 && slo.id) {
      locator === null || locator === void 0 ? void 0 : locator.navigate({
        params: {
          sloId: slo.id
        }
      }, {
        replace: true
      });
    }
  };
  const handleNavigateToApm = () => {
    if ((slo === null || slo === void 0 ? void 0 : slo.indicator.type) === 'sli.apm.transactionDuration' || (slo === null || slo === void 0 ? void 0 : slo.indicator.type) === 'sli.apm.transactionErrorRate') {
      const {
        indicator: {
          params: {
            environment,
            filter,
            service,
            transactionName,
            transactionType
          }
        },
        timeWindow: {
          duration
        }
      } = slo;
      const url = (0, _convert_sli_apm_params_to_apm_app_deeplink_url.convertSliApmParamsToApmAppDeeplinkUrl)({
        duration,
        environment,
        filter,
        service,
        transactionName,
        transactionType
      });
      navigate(basePath.prepend(url));
    }
  };
  const handleClone = async () => {
    if (slo) {
      setIsPopoverOpen(false);
      const newSlo = (0, _process_slo_form_values.transformCreateSLOFormToCreateSLOInput)((0, _process_slo_form_values.transformSloResponseToCreateSloForm)({
        ...slo,
        name: `[Copy] ${slo.name}`
      }));
      cloneSlo({
        slo: newSlo,
        originalSloId: slo.id
      });
      navigate(basePath.prepend(_paths.paths.observability.slos));
    }
  };
  const handleDelete = () => {
    setDeleteConfirmationModalOpen(true);
    setIsPopoverOpen(false);
  };
  const handleDeleteCancel = () => {
    setDeleteConfirmationModalOpen(false);
  };
  const handleDeleteConfirm = async () => {
    if (slo) {
      deleteSlo({
        id: slo.id,
        name: slo.name
      });
      navigate(basePath.prepend(_paths.paths.observability.slos));
    }
  };
  const navigate = (0, _react.useCallback)(url => setTimeout(() => navigateToUrl(url)), [navigateToUrl]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "sloDetailsHeaderControlPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11yHeaderControlActionsButton",
      fill: true,
      iconSide: "right",
      iconType: "arrowDown",
      iconSize: "s",
      onClick: handleActionsClick,
      disabled: isLoading || !slo
    }, _i18n.i18n.translate('xpack.observability.slo.sloDetails.headerControl.actions', {
      defaultMessage: 'Actions'
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "m",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "edit",
      disabled: !hasWriteCapabilities,
      icon: "pencil",
      onClick: handleEdit,
      "data-test-subj": "sloDetailsHeaderControlPopoverEdit"
    }, _i18n.i18n.translate('xpack.observability.slo.sloDetails.headerControl.edit', {
      defaultMessage: 'Edit'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createBurnRateRule",
      disabled: !hasWriteCapabilities,
      icon: "bell",
      onClick: handleOpenRuleFlyout,
      "data-test-subj": "sloDetailsHeaderControlPopoverCreateRule"
    }, _i18n.i18n.translate('xpack.observability.slo.sloDetails.headerControl.createBurnRateRule', {
      defaultMessage: 'Create new alert rule'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "manageRules",
      disabled: !hasWriteCapabilities,
      icon: "gear",
      onClick: handleNavigateToRules,
      "data-test-subj": "sloDetailsHeaderControlPopoverManageRules"
    }, _i18n.i18n.translate('xpack.observability.slo.sloDetails.headerControl.manageRules', {
      defaultMessage: 'Manage rules'
    }))].concat(!!slo && (0, _indicator.isApmIndicatorType)(slo.indicator.type) ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "exploreInApm",
      icon: "bullseye",
      onClick: handleNavigateToApm,
      "data-test-subj": "sloDetailsHeaderControlPopoverExploreInApm"
    }, _i18n.i18n.translate('xpack.observability.slos.sloDetails.headerControl.exploreInApm', {
      defaultMessage: 'Service details'
    })) : []).concat( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "clone",
      disabled: !hasWriteCapabilities,
      icon: "copy",
      onClick: handleClone,
      "data-test-subj": "sloDetailsHeaderControlPopoverClone"
    }, _i18n.i18n.translate('xpack.observability.slo.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "delete",
      icon: "trash",
      disabled: !hasWriteCapabilities,
      onClick: handleDelete,
      "data-test-subj": "sloDetailsHeaderControlPopoverDelete"
    }, _i18n.i18n.translate('xpack.observability.slo.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    })))
  })), !!slo && isRuleFlyoutVisible ? /*#__PURE__*/_react.default.createElement(AddRuleFlyout, {
    consumer: _common.sloFeatureId,
    ruleTypeId: _constants.SLO_BURN_RATE_RULE_TYPE_ID,
    canChangeTrigger: false,
    onClose: onCloseRuleFlyout,
    initialValues: {
      name: `${slo.name} burn rate`,
      params: {
        sloId: slo.id
      }
    }
  }) : null, slo && isDeleteConfirmationModalOpen ? /*#__PURE__*/_react.default.createElement(_slo_delete_confirmation_modal.SloDeleteConfirmationModal, {
    slo: slo,
    onCancel: handleDeleteCancel,
    onConfirm: handleDeleteConfirm
  }) : null);
}