"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rulesStatusesTranslationsMapping = exports.deleteSuccessText = exports.deleteErrorText = exports.confirmModalText = exports.confirmButtonText = exports.cancelButtonText = exports.TAGS_TITLE = exports.RULE_LOAD_ERROR = exports.ON_WORD = exports.LAST_UPDATED_MESSAGE = exports.EXECUTION_LOG_ERROR = exports.CREATED_WORD = exports.BY_WORD = exports.ALERT_STATUS_WARNING = exports.ALERT_STATUS_UNKNOWN = exports.ALERT_STATUS_PENDING = exports.ALERT_STATUS_OK = exports.ALERT_STATUS_LICENSE_ERROR = exports.ALERT_STATUS_ERROR = exports.ALERT_STATUS_ACTIVE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_LOAD_ERROR = errorMessage => _i18n.i18n.translate('xpack.observability.ruleDetails.ruleLoadError', {
  defaultMessage: 'Unable to load rule. Reason: {message}',
  values: {
    message: errorMessage
  }
});
exports.RULE_LOAD_ERROR = RULE_LOAD_ERROR;
const EXECUTION_LOG_ERROR = errorMessage => _i18n.i18n.translate('xpack.observability.ruleDetails.executionLogError', {
  defaultMessage: 'Unable to load rule execution log. Reason: {message}',
  values: {
    message: errorMessage
  }
});
exports.EXECUTION_LOG_ERROR = EXECUTION_LOG_ERROR;
const TAGS_TITLE = _i18n.i18n.translate('xpack.observability.ruleDetails.tagsTitle', {
  defaultMessage: 'Tags'
});
exports.TAGS_TITLE = TAGS_TITLE;
const LAST_UPDATED_MESSAGE = _i18n.i18n.translate('xpack.observability.ruleDetails.lastUpdatedMessage', {
  defaultMessage: 'Last updated'
});
exports.LAST_UPDATED_MESSAGE = LAST_UPDATED_MESSAGE;
const BY_WORD = _i18n.i18n.translate('xpack.observability.ruleDetails.byWord', {
  defaultMessage: 'by'
});
exports.BY_WORD = BY_WORD;
const ON_WORD = _i18n.i18n.translate('xpack.observability.ruleDetails.onWord', {
  defaultMessage: 'on'
});
exports.ON_WORD = ON_WORD;
const CREATED_WORD = _i18n.i18n.translate('xpack.observability.ruleDetails.createdWord', {
  defaultMessage: 'Created'
});
exports.CREATED_WORD = CREATED_WORD;
const confirmModalText = (numIdsToDelete, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.observability.rules.deleteSelectedIdsConfirmModal.descriptionText', {
  defaultMessage: "You can't recover {numIdsToDelete, plural, one {a deleted {singleTitle}} other {deleted {multipleTitle}}}.",
  values: {
    numIdsToDelete,
    singleTitle,
    multipleTitle
  }
});
exports.confirmModalText = confirmModalText;
const confirmButtonText = (numIdsToDelete, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.observability.rules.deleteSelectedIdsConfirmModal.deleteButtonLabel', {
  defaultMessage: 'Delete {numIdsToDelete, plural, one {{singleTitle}} other {# {multipleTitle}}} ',
  values: {
    numIdsToDelete,
    singleTitle,
    multipleTitle
  }
});
exports.confirmButtonText = confirmButtonText;
const cancelButtonText = _i18n.i18n.translate('xpack.observability.rules.deleteSelectedIdsConfirmModal.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
exports.cancelButtonText = cancelButtonText;
const deleteSuccessText = (numSuccesses, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.observability.rules.deleteSelectedIdsSuccessNotification.descriptionText', {
  defaultMessage: 'Deleted {numSuccesses, number} {numSuccesses, plural, one {{singleTitle}} other {{multipleTitle}}}',
  values: {
    numSuccesses,
    singleTitle,
    multipleTitle
  }
});
exports.deleteSuccessText = deleteSuccessText;
const deleteErrorText = (numErrors, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.observability.rules.deleteSelectedIdsErrorNotification.descriptionText', {
  defaultMessage: 'Failed to delete {numErrors, number} {numErrors, plural, one {{singleTitle}} other {{multipleTitle}}}',
  values: {
    numErrors,
    singleTitle,
    multipleTitle
  }
});
exports.deleteErrorText = deleteErrorText;
const ALERT_STATUS_LICENSE_ERROR = _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusLicenseError', {
  defaultMessage: 'License Error'
});
exports.ALERT_STATUS_LICENSE_ERROR = ALERT_STATUS_LICENSE_ERROR;
const ALERT_STATUS_OK = _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusOk', {
  defaultMessage: 'Ok'
});
exports.ALERT_STATUS_OK = ALERT_STATUS_OK;
const ALERT_STATUS_ACTIVE = _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusActive', {
  defaultMessage: 'Active'
});
exports.ALERT_STATUS_ACTIVE = ALERT_STATUS_ACTIVE;
const ALERT_STATUS_ERROR = _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusError', {
  defaultMessage: 'Error'
});
exports.ALERT_STATUS_ERROR = ALERT_STATUS_ERROR;
const ALERT_STATUS_PENDING = _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusPending', {
  defaultMessage: 'Pending'
});
exports.ALERT_STATUS_PENDING = ALERT_STATUS_PENDING;
const ALERT_STATUS_UNKNOWN = _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusUnknown', {
  defaultMessage: 'Unknown'
});
exports.ALERT_STATUS_UNKNOWN = ALERT_STATUS_UNKNOWN;
const ALERT_STATUS_WARNING = _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusWarning', {
  defaultMessage: 'Warning'
});
exports.ALERT_STATUS_WARNING = ALERT_STATUS_WARNING;
const rulesStatusesTranslationsMapping = {
  ok: ALERT_STATUS_OK,
  active: ALERT_STATUS_ACTIVE,
  error: ALERT_STATUS_ERROR,
  pending: ALERT_STATUS_PENDING,
  unknown: ALERT_STATUS_UNKNOWN,
  warning: ALERT_STATUS_WARNING
};
exports.rulesStatusesTranslationsMapping = rulesStatusesTranslationsMapping;