"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptySections = EmptySections;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = require("styled-components");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_react = require("../../../../../utils/kibana_react");
var _paths = require("../../../../../config/paths");
var _use_has_data = require("../../../../../hooks/use_has_data");
var _empty_section = require("./empty_section");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmptySections() {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext);
  const {
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const appEmptySections = getEmptySections({
    http
  }).filter(({
    id
  }) => {
    const app = hasDataMap[id];
    if (app) {
      return app.status === _public.FETCH_STATUS.FAILURE || !app.hasData;
    }
    return false;
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns:
    // when more than 2 empty sections are available show them on 2 columns, otherwise 1
    appEmptySections.length > 2 ? 2 : 1,
    gutterSize: "s"
  }, appEmptySections.map(app => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: app.id,
      style: {
        border: `${theme.eui.euiBorderEditable}`,
        borderRadius: `${theme.eui.euiBorderRadius}`
      }
    }, /*#__PURE__*/_react.default.createElement(_empty_section.EmptySection, {
      section: app
    }));
  })));
}
const getEmptySections = ({
  http
}) => {
  return [{
    id: 'infra_logs',
    title: _i18n.i18n.translate('xpack.observability.emptySection.apps.logs.title', {
      defaultMessage: 'Logs'
    }),
    icon: 'logoLogging',
    description: _i18n.i18n.translate('xpack.observability.emptySection.apps.logs.description', {
      defaultMessage: 'Fast, easy, and scalable centralized log monitoring with out-of-the-box support for common data sources.'
    }),
    linkTitle: _i18n.i18n.translate('xpack.observability.emptySection.apps.logs.link', {
      defaultMessage: 'Install Filebeat'
    }),
    href: http.basePath.prepend('/app/home#/tutorial_directory/logging')
  }, {
    id: 'apm',
    title: _i18n.i18n.translate('xpack.observability.emptySection.apps.apm.title', {
      defaultMessage: 'APM'
    }),
    icon: 'logoObservability',
    description: _i18n.i18n.translate('xpack.observability.emptySection.apps.apm.description', {
      defaultMessage: 'Get deeper visibility into your applications with extensive support for popular languages, OpenTelemetry, and distributed tracing.'
    }),
    linkTitle: _i18n.i18n.translate('xpack.observability.emptySection.apps.apm.link', {
      defaultMessage: 'Install Agent'
    }),
    href: http.basePath.prepend('/app/home#/tutorial/apm')
  }, {
    id: 'infra_metrics',
    title: _i18n.i18n.translate('xpack.observability.emptySection.apps.metrics.title', {
      defaultMessage: 'Metrics'
    }),
    icon: 'logoMetrics',
    description: _i18n.i18n.translate('xpack.observability.emptySection.apps.metrics.description', {
      defaultMessage: 'Stream, visualize, and analyze your infrastructure metrics.'
    }),
    linkTitle: _i18n.i18n.translate('xpack.observability.emptySection.apps.metrics.link', {
      defaultMessage: 'Install Metricbeat'
    }),
    href: http.basePath.prepend('/app/home#/tutorial_directory/metrics')
  }, {
    id: 'uptime',
    title: _i18n.i18n.translate('xpack.observability.emptySection.apps.uptime.title', {
      defaultMessage: 'Uptime'
    }),
    icon: 'logoUptime',
    description: _i18n.i18n.translate('xpack.observability.emptySection.apps.uptime.description', {
      defaultMessage: 'Proactively monitor the availability and functionality of user journeys.'
    }),
    linkTitle: _i18n.i18n.translate('xpack.observability.emptySection.apps.uptime.link', {
      defaultMessage: 'Install Heartbeat'
    }),
    href: http.basePath.prepend('/app/home#/tutorial/uptimeMonitors')
  }, {
    id: 'ux',
    title: _i18n.i18n.translate('xpack.observability.emptySection.apps.ux.title', {
      defaultMessage: 'User Experience'
    }),
    icon: 'logoObservability',
    description: _i18n.i18n.translate('xpack.observability.emptySection.apps.ux.description', {
      defaultMessage: 'Collect, measure, and analyze performance data that reflects real-world user experiences.'
    }),
    linkTitle: _i18n.i18n.translate('xpack.observability.emptySection.apps.ux.link', {
      defaultMessage: 'Install RUM Agent'
    }),
    href: http.basePath.prepend('/app/home#/tutorial/apm')
  }, {
    id: 'alert',
    title: _i18n.i18n.translate('xpack.observability.emptySection.apps.alert.title', {
      defaultMessage: 'No alerts found.'
    }),
    icon: 'watchesApp',
    description: _i18n.i18n.translate('xpack.observability.emptySection.apps.alert.description', {
      defaultMessage: 'Detect complex conditions within Observability and trigger actions when those conditions are met.'
    }),
    linkTitle: _i18n.i18n.translate('xpack.observability.emptySection.apps.alert.link', {
      defaultMessage: 'Create rule'
    }),
    href: http.basePath.prepend(_paths.paths.observability.rules)
  }];
};