"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingPage = LandingPage;
var _react = _interopRequireDefault(require("react"));
var _use_has_data = require("../../hooks/use_has_data");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LandingPage() {
  const {
    hasDataMap,
    isAllRequestsComplete
  } = (0, _use_has_data.useHasData)();
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  if (isAllRequestsComplete) {
    const {
      apm,
      infra_logs: logs
    } = hasDataMap;
    const hasApmData = apm === null || apm === void 0 ? void 0 : apm.hasData;
    const hasLogsData = logs === null || logs === void 0 ? void 0 : logs.hasData;
    if (hasLogsData) {
      navigateToUrl(basePath.prepend('/app/discover'));
    } else if (hasApmData) {
      navigateToUrl(basePath.prepend('/app/apm/services'));
    } else {
      navigateToUrl(basePath.prepend('/app/observabilityOnboarding'));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}