"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderRuleStats = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Divider = _common.euiStyled.div`
  border-right: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  height: 100%;
`;
const StyledStat = (0, _common.euiStyled)(_eui.EuiStat)`
  .euiText {
    line-height: 1;
  }
`;
const ConditionalWrap = ({
  condition,
  wrap,
  children
}) => condition ? wrap(children) : children;
const getStatCount = (stats, statType) => {
  if (statType === 'snoozed') return stats.snoozed + stats.muted;
  return stats[statType];
};
const renderRuleStats = (ruleStats, manageRulesHref, ruleStatsLoading) => {
  const createRuleStatsLink = (stats, statType) => {
    const count = getStatCount(stats, statType);
    let statsLink = `${manageRulesHref}?_a=(lastResponse:!(),status:!())`;
    if (count > 0) {
      switch (statType) {
        case 'error':
          statsLink = `${manageRulesHref}?_a=(lastResponse:!(error),status:!())`;
          break;
        case 'snoozed':
        case 'disabled':
          statsLink = `${manageRulesHref}?_a=(lastResponse:!(),status:!(${statType}))`;
          break;
        default:
          break;
      }
    }
    return statsLink;
  };
  const disabledStatsComponent = /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: ruleStats.disabled > 0,
    wrap: wrappedChildren => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11yDisabledStatsComponentButton",
      href: createRuleStatsLink(ruleStats, 'disabled')
    }, wrappedChildren)
  }, /*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.disabled,
    description: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.disabled', {
      defaultMessage: 'Disabled'
    }),
    color: "primary",
    titleColor: ruleStats.disabled > 0 ? 'primary' : '',
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statDisabled"
  }));
  const snoozedStatsComponent = /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: ruleStats.muted + ruleStats.snoozed > 0,
    wrap: wrappedChildren => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11ySnoozedStatsComponentButton",
      href: createRuleStatsLink(ruleStats, 'snoozed')
    }, wrappedChildren)
  }, /*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.muted + ruleStats.snoozed,
    description: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.muted', {
      defaultMessage: 'Snoozed'
    }),
    color: "primary",
    titleColor: ruleStats.muted + ruleStats.snoozed > 0 ? 'primary' : '',
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statMuted"
  }));
  const errorStatsComponent = /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: ruleStats.error > 0,
    wrap: wrappedChildren => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11yErrorStatsComponentButton",
      href: createRuleStatsLink(ruleStats, 'error')
    }, wrappedChildren)
  }, /*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.error,
    description: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.errors', {
      defaultMessage: 'Errors'
    }),
    color: "primary",
    titleColor: ruleStats.error > 0 ? 'primary' : '',
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statErrors"
  }));
  return [/*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.total,
    description: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.ruleCount', {
      defaultMessage: 'Rule count'
    }),
    color: "primary",
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statRuleCount"
  }), disabledStatsComponent, snoozedStatsComponent, errorStatsComponent, /*#__PURE__*/_react.default.createElement(Divider, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "manageRulesPageButton",
    href: manageRulesHref
  }, _i18n.i18n.translate('xpack.observability.alerts.manageRulesButtonLabel', {
    defaultMessage: 'Manage Rules'
  }))].reverse();
};
exports.renderRuleStats = renderRuleStats;