"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSloDetailsPath = exports.SloDetailsLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSloDetailsPath = sloId => {
  return `/slos/${encodeURI(sloId)}`;
};
exports.getSloDetailsPath = getSloDetailsPath;
class SloDetailsLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _common.sloDetailsLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      sloId = ''
    }) => {
      return {
        app: 'observability',
        path: getSloDetailsPath(sloId),
        state: {}
      };
    });
  }
}
exports.SloDetailsLocatorDefinition = SloDetailsLocatorDefinition;