"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchDataViews = useFetchDataViews;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchDataViews({
  name = '',
  size = 10
}) {
  const {
    dataViews
  } = (0, _kibana_react.useKibana)().services;
  const search = name.endsWith('*') ? name : `${name}*`;
  const {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchDataViews', search],
    queryFn: async () => {
      try {
        return await dataViews.find(search, size);
      } catch (error) {
        throw new Error(`Something went wrong. Error: ${error}`);
      }
    }
  });
  return {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  };
}