"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloGlobalDiagnosis = useFetchSloGlobalDiagnosis;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../utils/kibana_react");
var _convert_error_for_use_in_toast = require("./helpers/convert_error_for_use_in_toast");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloGlobalDiagnosis() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.globalDiagnosis(),
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.get('/internal/observability/slos/_diagnosis', {
          query: {},
          signal
        });
        return response;
      } catch (error) {
        throw (0, _convert_error_for_use_in_toast.convertErrorForUseInToast)(error);
      }
    },
    keepPreviousData: true,
    refetchOnWindowFocus: false,
    retry: false,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.observability.slo.globalDiagnosis.errorNotification', {
          defaultMessage: 'You do not have the right permissions to use this feature.'
        })
      });
    }
  });
  return {
    globalSloDiagnosis: data,
    isLoading,
    isInitialLoading,
    isRefetching,
    isSuccess,
    isError,
    refetch
  };
}