"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchActiveAlerts = useFetchActiveAlerts;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/rule-registry-plugin/common");
var _kibana_react = require("../../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_ACTIVE_ALERTS_MAP = {};
function useFetchActiveAlerts({
  sloIds = []
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.activeAlert(sloIds),
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.post(`${_common.BASE_RAC_ALERTS_API_PATH}/find`, {
          body: JSON.stringify({
            feature_ids: ['slo'],
            size: 0,
            query: {
              bool: {
                filter: [{
                  range: {
                    '@timestamp': {
                      gte: 'now-5m/m'
                    }
                  }
                }, {
                  term: {
                    'kibana.alert.rule.rule_type_id': 'slo.rules.burnRate'
                  }
                }, {
                  term: {
                    'kibana.alert.status': 'active'
                  }
                }]
              }
            },
            aggs: {
              perSloId: {
                terms: {
                  field: 'kibana.alert.rule.parameters.sloId'
                },
                aggs: {
                  perRuleId: {
                    terms: {
                      field: 'kibana.alert.rule.uuid'
                    }
                  }
                }
              }
            }
          }),
          signal
        });
        return response.aggregations.perSloId.buckets.reduce((acc, bucket) => {
          var _bucket$doc_count;
          return {
            ...acc,
            [bucket.key]: {
              count: (_bucket$doc_count = bucket.doc_count) !== null && _bucket$doc_count !== void 0 ? _bucket$doc_count : 0,
              ruleIds: bucket.perRuleId.buckets.map(rule => rule.key)
            }
          };
        }, {});
      } catch (error) {
        // ignore error
      }
    },
    refetchOnWindowFocus: false
  });
  return {
    data: isInitialLoading ? EMPTY_ACTIVE_ALERTS_MAP : data !== null && data !== void 0 ? data : EMPTY_ACTIVE_ALERTS_MAP,
    isLoading: isInitialLoading || isLoading || isRefetching,
    isSuccess,
    isError
  };
}