"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.translations = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const translations = {
  alertsTable: {
    viewDetailsTextLabel: _i18n.i18n.translate('xpack.observability.alertsTable.viewDetailsTextLabel', {
      defaultMessage: 'View details'
    }),
    viewInAppTextLabel: _i18n.i18n.translate('xpack.observability.alertsTable.viewInAppTextLabel', {
      defaultMessage: 'View in app'
    }),
    moreActionsTextLabel: _i18n.i18n.translate('xpack.observability.alertsTable.moreActionsTextLabel', {
      defaultMessage: 'More actions'
    }),
    notEnoughPermissions: _i18n.i18n.translate('xpack.observability.alertsTable.notEnoughPermissions', {
      defaultMessage: 'Additional privileges required'
    }),
    statusColumnDescription: _i18n.i18n.translate('xpack.observability.alertsTGrid.statusColumnDescription', {
      defaultMessage: 'Alert Status'
    }),
    lastUpdatedColumnDescription: _i18n.i18n.translate('xpack.observability.alertsTGrid.lastUpdatedColumnDescription', {
      defaultMessage: 'Last updated'
    }),
    durationColumnDescription: _i18n.i18n.translate('xpack.observability.alertsTGrid.durationColumnDescription', {
      defaultMessage: 'Duration'
    }),
    reasonColumnDescription: _i18n.i18n.translate('xpack.observability.alertsTGrid.reasonColumnDescription', {
      defaultMessage: 'Reason'
    }),
    actionsTextLabel: _i18n.i18n.translate('xpack.observability.alertsTable.actionsTextLabel', {
      defaultMessage: 'Actions'
    }),
    loadingTextLabel: _i18n.i18n.translate('xpack.observability.alertsTable.loadingTextLabel', {
      defaultMessage: 'loading alerts'
    }),
    footerTextLabel: _i18n.i18n.translate('xpack.observability.alertsTable.footerTextLabel', {
      defaultMessage: 'alerts'
    }),
    showingAlertsTitle: totalAlerts => _i18n.i18n.translate('xpack.observability.alertsTable.showingAlertsTitle', {
      values: {
        totalAlerts
      },
      defaultMessage: '{totalAlerts, plural, =1 {alert} other {alerts}}'
    }),
    viewRuleDetailsButtonText: _i18n.i18n.translate('xpack.observability.alertsTable.viewRuleDetailsButtonText', {
      defaultMessage: 'View rule details'
    }),
    viewAlertDetailsButtonText: _i18n.i18n.translate('xpack.observability.alertsTable.viewAlertDetailsButtonText', {
      defaultMessage: 'View alert details'
    }),
    viewAlertDetailsPageButtonText: _i18n.i18n.translate('xpack.observability.alertsTable.viewAlertDetailsPageButtonText', {
      defaultMessage: 'View alert page'
    })
  },
  alertsFlyout: {
    statusLabel: _i18n.i18n.translate('xpack.observability.alertsFlyout.statusLabel', {
      defaultMessage: 'Status'
    }),
    lastUpdatedLabel: _i18n.i18n.translate('xpack.observability.alertsFlyout.lastUpdatedLabel', {
      defaultMessage: 'Last updated'
    }),
    startedAtLabel: _i18n.i18n.translate('xpack.observability.alertsFlyout.startedAtLabel', {
      defaultMessage: 'Started at'
    }),
    durationLabel: _i18n.i18n.translate('xpack.observability.alertsFlyout.durationLabel', {
      defaultMessage: 'Duration'
    }),
    expectedValueLabel: _i18n.i18n.translate('xpack.observability.alertsFlyout.expectedValueLabel', {
      defaultMessage: 'Expected value'
    }),
    actualValueLabel: _i18n.i18n.translate('xpack.observability.alertsFlyout.actualValueLabel', {
      defaultMessage: 'Actual value'
    }),
    ruleTypeLabel: _i18n.i18n.translate('xpack.observability.alertsFlyout.ruleTypeLabel', {
      defaultMessage: 'Rule type'
    }),
    reasonTitle: _i18n.i18n.translate('xpack.observability.alertsFlyout.reasonTitle', {
      defaultMessage: 'Reason'
    }),
    viewRulesDetailsLinkText: _i18n.i18n.translate('xpack.observability.alertsFlyout.viewRulesDetailsLinkText', {
      defaultMessage: 'View rule details'
    }),
    documentSummaryTitle: _i18n.i18n.translate('xpack.observability.alertsFlyout.documentSummaryTitle', {
      defaultMessage: 'Document Summary'
    }),
    viewInAppButtonText: _i18n.i18n.translate('xpack.observability.alertsFlyout.viewInAppButtonText', {
      defaultMessage: 'View in app'
    }),
    alertDetailsButtonText: _i18n.i18n.translate('xpack.observability.alertsFlyout.alertsDetailsButtonText', {
      defaultMessage: 'Alert details'
    })
  }
};
exports.translations = translations;